/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk;

import com.mysql.cj.jdbc.JdbcStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.archive.WriteArchiveContext;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.db.pktemptable.table.PostgreSqlPKTempTableOperator;
import kd.bos.db.pktemptable.utils.DBFeaturesUtils;
import kd.bos.db.temptable.pk.SQLServerBulkInsert;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.registry.PKTempTableRegistry;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import org.mariadb.jdbc.MariaDbStatement;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public final class PKTempTableUtil {
    static final Log log = LogFactory.getLog((String)"DB");

    private PKTempTableUtil() {
    }

    public static void dropPKTable(String table, DBRoute route) {
        try (WriteArchiveContext ctx = WriteArchiveContext.create(route.getRouteKey());){
            TX.__setRouteForceMaster(route.getRouteKey());
            try (TXHandle h = TX.requiresNew("Drop_PKTemp");){
                String sql;
                boolean isOracleOrDM;
                DBType dbType = DB.getDBType(route);
                boolean bl = isOracleOrDM = dbType == DBType.Oracle || dbType == DBType.DM || dbType == DBType.OceanBase_Oracle;
                if (isOracleOrDM) {
                    PKTempTableUtil.truncateTable(route, table);
                    sql = PKTempTableUtil.wrapDialectNoShardingSQL("DROP TABLE " + table + " PURGE");
                } else {
                    sql = PKTempTableUtil.wrapDialectNoShardingSQL("DROP TABLE " + table);
                }
                DB.execute(route, sql);
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    public static boolean existsPKTable(String table, DBRoute route) {
        return DB.exitsTable(route, table);
    }

    public static String genPKTableName(PKTempTableType tempTableType) {
        String suffix = PKTempTableRegistry.get().getTableNameSuffix();
        return tempTableType.genTableName(ID.longTo36Radix((long)ID.genLongId())) + suffix;
    }

    public static void createPKTable(DBRoute route, PKTempTableType tempTableType, String pkTable) {
        try {
            String createTableSQL;
            TX.__setRouteForceMaster(route.getRouteKey());
            int bigStringLength = PKTempTableConfig.getBigStringLength();
            DBType dbType = DB.getDBType(route);
            boolean createTableWithIndex = false;
            switch (dbType) {
                case OceanBase_Oracle: {
                    String fieldType = tempTableType == PKTempTableType.PK_LONG ? (dbType == DBType.DM ? "BIGINT" : "NUMBER(19)") : (tempTableType == PKTempTableType.PK_STRING ? "VARCHAR(" + PKTempTableConfig.getPkStringLength() + ")" : "NVARCHAR2(" + bigStringLength + ')');
                    createTableSQL = "CREATE TABLE " + pkTable + " (FID " + fieldType + ")";
                    break;
                }
                case DM: 
                case Oracle: {
                    String fieldType = tempTableType == PKTempTableType.PK_LONG ? (dbType == DBType.DM ? "BIGINT" : "NUMBER(19)") : (tempTableType == PKTempTableType.PK_STRING ? "VARCHAR(" + PKTempTableConfig.getPkStringLength() + ")" : "NVARCHAR2(" + bigStringLength + ')');
                    createTableSQL = "CREATE TABLE " + pkTable + " (FID " + fieldType + ") nologging";
                    break;
                }
                case GS: 
                case GS100: 
                case PostgreSQL: 
                case Greenplum: 
                case GaussDB: 
                case Gauss200: 
                case KingBase: 
                case Gbase: 
                case Vastbase: 
                case YasDB: {
                    String fieldType = tempTableType == PKTempTableType.PK_LONG ? "BIGINT" : (tempTableType == PKTempTableType.PK_STRING ? "VARCHAR(" + PKTempTableConfig.getPkStringLength() + ")" : "VARCHAR(" + bigStringLength + ')');
                    if (DBType.PostgreSQL == dbType && PKTempTableConfig.isPgUseUnloggedTable()) {
                        createTableSQL = "CREATE UNLOGGED TABLE " + pkTable + "(FID " + fieldType + ')';
                        break;
                    }
                    if (DBType.YasDB == dbType) {
                        createTableSQL = "CREATE TABLE " + pkTable + "(FID " + fieldType + ")";
                        if (!kd.bos.db.pktemptable.config.PKTempTableConfig.isYasUseNologging()) break;
                        createTableSQL = createTableSQL + " nologging";
                        break;
                    }
                    createTableSQL = "CREATE TABLE " + pkTable + "(FID " + fieldType + ')';
                    break;
                }
                case SQLServer: {
                    String fieldType = tempTableType == PKTempTableType.PK_LONG ? "BIGINT" : (tempTableType == PKTempTableType.PK_STRING ? "NVARCHAR(" + PKTempTableConfig.getPkStringLength() + ")" : "NVARCHAR(" + bigStringLength + ')');
                    createTableSQL = "CREATE TABLE " + pkTable + "(FID " + fieldType + ')';
                    break;
                }
                default: {
                    createTableWithIndex = true;
                    String fieldType = tempTableType == PKTempTableType.PK_LONG ? "BIGINT(19)" : (tempTableType == PKTempTableType.PK_STRING ? "VARCHAR(" + PKTempTableConfig.getPkStringLength() + ")" : "VARCHAR(" + bigStringLength + ')');
                    createTableSQL = "CREATE TABLE " + pkTable + "(FID " + fieldType + ", KEY IX_FID(FID))";
                    if (dbType != DBType.MySQL && dbType != DBType.TDSQL && dbType != DBType.TiDB) break;
                    if (PKTempTableConfig.isMySQLUseMemoryEngine()) {
                        createTableSQL = createTableSQL + " ENGINE=MEMORY";
                    }
                    if (tempTableType == PKTempTableType.PK_LONG || PKTempTableConfig.isMysqlUseDbDefaultCharset()) break;
                    String tpl = " DEFAULT CHARSET=%s COLLATE=%s";
                    createTableSQL = createTableSQL + String.format(tpl, PKTempTableConfig.getMysqlTableCharset(), PKTempTableConfig.getMysqlTableCollate());
                }
            }
            try (TXHandle h = TX.requiresNew("temp_create");
                 WriteArchiveContext ctx = WriteArchiveContext.create(route.getRouteKey());){
                DB.execute(route, PKTempTableUtil.wrapDialectNoShardingSQL(createTableSQL));
                if (!createTableWithIndex && PKTempTableConfig.isTempWithIndex()) {
                    String createIndexSQL = PKTempTableUtil.wrapDialectNoShardingSQL("CREATE INDEX IX_" + pkTable + " ON " + pkTable + "(FID)");
                    DB.execute(route, createIndexSQL);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((String)("Create pkTempTable failed:" + e.getMessage()), (Throwable)e);
        }
    }

    public static void insertPKs(DBRoute route, String pkTable, Collection<? extends Object> noNullValueSet) {
        block98: {
            TX.__setRouteForceMaster(route.getRouteKey());
            DBType dbType = DB.getDBType(route);
            PKTempTableUtil.logInsertStack(noNullValueSet.size());
            try (TraceSpan ts = Tracer.create((String)"temptable.init", (String)"temptable.init");
                 TXHandle h = TX.requiresNew("temp_insert");
                 TXHandle h2 = TX.notSupported("temp_insert");
                 DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(route.getRouteKey(), false);){
                String sql;
                ts.addTag("count", String.valueOf(noNullValueSet.size()));
                if ((dbType == DBType.MySQL || dbType == DBType.TDSQL || dbType == DBType.TiDB) && PKTempTableConfig.isMySQLUseLoadInfile() && DBFeaturesUtils.supportedLoadDataInfile(route)) {
                    sql = PKTempTableUtil.wrapDialectNoShardingSQL("LOAD DATA LOCAL INFILE 'ids_" + noNullValueSet.size() + "' IGNORE INTO TABLE " + pkTable + "(FID)");
                    PKTempTableUtil.logInsertPKSelfExecuteSQL(sql, con, route);
                    StringBuilder sb = new StringBuilder(noNullValueSet.size() * 19);
                    for (Object object : noNullValueSet) {
                        sb.append(object).append('\n');
                    }
                    sb.setLength(sb.length() - 1);
                    Throwable throwable = null;
                    try (Statement stmt = con.createStatement();){
                        ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
                        if (DataSourceURLs.isUseMariaDbDriver()) {
                            MariaDbStatement mps = stmt.unwrap(MariaDbStatement.class);
                            mps.setLocalInfileInputStream((InputStream)bis);
                        } else {
                            JdbcStatement js = stmt.unwrap(JdbcStatement.class);
                            js.setLocalInfileInputStream((InputStream)bis);
                        }
                        stmt.execute(sql);
                        break block98;
                    }
                    catch (Throwable bis) {
                        Throwable throwable2 = bis;
                        throw bis;
                    }
                }
                if (dbType == DBType.SQLServer && PKTempTableConfig.isSqlServerUseBulk()) {
                    try {
                        new SQLServerBulkInsert(con, pkTable, noNullValueSet, route).insert();
                    }
                    catch (Exception ignored) {
                        PKTempTableUtil.batchInsert(dbType, con, route, pkTable, noNullValueSet);
                    }
                    break block98;
                }
                if (dbType == DBType.PostgreSQL && PKTempTableConfig.isPgUseCopyIn()) {
                    try {
                        sql = PKTempTableUtil.wrapDialectNoShardingSQL("COPY " + pkTable + "(FID) FROM STDIN DELIMITER AS ','");
                        PKTempTableUtil.logInsertPKSelfExecuteSQL(sql, con, route);
                        StringBuilder sb = new StringBuilder(noNullValueSet.size() * 21);
                        for (Object object : noNullValueSet) {
                            sb.append(object).append("\n");
                        }
                        sb.setLength(sb.length() - 1);
                        Throwable throwable = null;
                        try (PostgreSqlPKTempTableOperator.ConnectionAutoCommitResetter currentAutoCommit = PostgreSqlPKTempTableOperator.ConnectionAutoCommitResetter.currentAutoCommit(con, true);
                             ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));){
                            BaseConnection baseConn = con.unwrap(BaseConnection.class);
                            CopyManager mgr = new CopyManager(baseConn);
                            long begin = System.currentTimeMillis();
                            long copyCount = mgr.copyIn(sql, (InputStream)bis);
                            if (log.isInfoEnabled()) {
                                log.info("TempTable use copy insert succeed, cost ={}ms, copyCount = {}, toInsertCount = {}", new Object[]{System.currentTimeMillis() - begin, copyCount, noNullValueSet.size()});
                            }
                            break block98;
                        }
                        catch (Throwable throwable3) {
                            Throwable throwable4 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Exception ignore) {
                        PKTempTableUtil.batchInsert(dbType, con, route, pkTable, noNullValueSet);
                    }
                    break block98;
                }
                PKTempTableUtil.batchInsert(dbType, con, route, pkTable, noNullValueSet);
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
    }

    private static void batchInsert(DBType dbType, DelegateConnection con, DBRoute route, String pkTable, Collection<? extends Object> noNullValueSet) throws SQLException {
        String sql = null;
        String size_comment = "/*ids_" + noNullValueSet.size() + "*/";
        if (dbType == DBType.Oracle) {
            int parallel = noNullValueSet.size() >= 100000 ? 4 : 2;
            sql = PKTempTableUtil.wrapDialectNoShardingSQL(size_comment + "INSERT INTO /*+ append parallel(" + parallel + ")*/ " + pkTable + "(FID) VALUES(?)");
        } else {
            sql = PKTempTableUtil.wrapDialectNoShardingSQL(size_comment + "INSERT INTO " + pkTable + "(FID) VALUES(?)");
        }
        PKTempTableUtil.logInsertPKSelfExecuteSQL(sql, con, route);
        int batchSize = 5000;
        try (PreparedStatement ps = con.prepareStatement(sql);){
            int count = 0;
            for (Object object : noNullValueSet) {
                ps.setObject(1, object);
                ps.addBatch();
                if (++count % batchSize != 0) continue;
                ps.executeBatch();
            }
            if (count % batchSize > 0) {
                ps.executeBatch();
            }
        }
    }

    public static void truncateTable(DBRoute route, String pkTable) {
        try (WriteArchiveContext ctx = WriteArchiveContext.create(route.getRouteKey());){
            TX.__setRouteForceMaster(route.getRouteKey());
            String sql = PKTempTableUtil.wrapDialectNoShardingSQL("TRUNCATE TABLE " + pkTable);
            DB.execute(route, sql);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((String)"Truncate pkTempTable failed.", (Throwable)e);
        }
    }

    public static boolean existsPK(DBRoute route, String pkTable, Object pk) {
        try {
            String sql = "select 1 from " + pkTable + " where FID=?";
            sql = PKTempTableUtil.wrapDialectNoShardingSQL(sql);
            return DB.query(route, sql, new Object[]{pk}, rs -> rs.next());
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }

    private static void logInsertPKSelfExecuteSQL(String sql, DelegateConnection con, DBRoute route) throws SQLException {
        con.addWrited(sql);
        if (DB.isSqlOut()) {
            String dbLogTag = DB.isXDBEnable() ? "temp-in-xdb " : "temp-in-db ";
            StringBuilder msg = new StringBuilder(dbLogTag).append("----sql@").append(route.getRouteKey()).append("->").append(con.getRouteKey()).append("#con").append(con.id()).append("----\r\n").append(sql);
            if (log.isInfoEnabled()) {
                log.info(msg.toString());
            } else {
                DisCardUtil.discard();
            }
        }
    }

    private static String wrapDialectNoShardingSQL(String sql) {
        return "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
    }

    public static boolean isReadOnlyException(Exception e) {
        String readOnlyKey = "super-read-only";
        if (e instanceof SQLException) {
            return e.getMessage().contains(readOnlyKey);
        }
        if (e instanceof RuntimeException) {
            Throwable throwable;
            for (throwable = e.getCause(); throwable != null && throwable.getCause() != null; throwable = throwable.getCause()) {
            }
            if (throwable instanceof SQLException) {
                return throwable.getMessage().contains(readOnlyKey);
            }
        }
        return false;
    }

    private static void logInsertStack(int insertSize) {
        int threshold = PKTempTableConfig.getLogStackThreshold();
        if (threshold > 0 && insertSize >= threshold) {
            Throwable throwable = new Throwable("LogInsertPKTempTablePksStack: " + insertSize);
            log.warn(throwable);
        }
    }
}

