/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkData;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.db.tx.TX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerBulkInsert {
    private static final Logger log = LoggerFactory.getLogger(SQLServerBulkInsert.class);
    private final Connection conn;
    private final Collection<?> noNullValueSet;
    private final DBRoute route;
    private final PKTempTableType tableType;
    private final String tableName;

    public SQLServerBulkInsert(Connection conn, String tableName, Collection<?> noNullValueSet, DBRoute route) {
        this.conn = conn;
        this.noNullValueSet = noNullValueSet;
        this.route = route;
        this.tableName = tableName;
        Object first = noNullValueSet.iterator().next();
        if (first instanceof Number) {
            this.tableType = PKTempTableType.PK_LONG;
        } else if (first instanceof String) {
            this.tableType = ((String)first).length() <= 32 ? PKTempTableType.PK_STRING : PKTempTableType.PK_BIGSTRING;
        } else {
            throw new RuntimeException("Unknown value type:" + first.getClass().getName());
        }
    }

    public void insert() throws SQLException {
        long startTimestamp = System.currentTimeMillis();
        TX.__setRouteForceMaster(this.route.getRouteKey());
        SQLServerBulkArrayRecord bulk = new SQLServerBulkArrayRecord(this.noNullValueSet, this.tableType);
        Connection realConn = (Connection)this.conn.unwrap(SQLServerConnection.class);
        SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy(realConn);
        bulkCopy.setDestinationTableName(this.tableName);
        bulkCopy.writeToServer((ISQLServerBulkData)bulk);
        log.info("/* BULK_INSERT_LOG:{} COST {}ms */BULK INSERT FROM {}", new Object[]{this.noNullValueSet.size(), System.currentTimeMillis() - startTimestamp, this.tableName});
    }

    private static class ColumnMetadata {
        public final String columnName;
        public final int columnType;
        public final int precision;
        public final int scale;

        public ColumnMetadata(String columnName, int columnType, int precision, int scale) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.precision = precision;
            this.scale = scale;
        }
    }

    private static class SQLServerBulkArrayRecord
    implements ISQLServerBulkRecord {
        private Map<Integer, ColumnMetadata> columnMetadata = new HashMap<Integer, ColumnMetadata>();
        private int position = -1;
        private final List<Object[]> data;
        private Object[] current;

        public SQLServerBulkArrayRecord(Collection<?> noNullValueSet, PKTempTableType type) {
            this.data = new ArrayList<Object[]>(noNullValueSet.size());
            switch (type) {
                case PK_STRING: {
                    this.columnMetadata.put(1, new ColumnMetadata("FID", -9, 32, 0));
                    break;
                }
                case PK_LONG: {
                    this.columnMetadata.put(1, new ColumnMetadata("FID", -5, 0, 0));
                    break;
                }
                case PK_BIGSTRING: {
                    this.columnMetadata.put(1, new ColumnMetadata("FID", -9, PKTempTableConfig.getBigStringLength(), 0));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown pkTempTable type:" + (Object)((Object)type));
                }
            }
            for (Object value : noNullValueSet) {
                Object v = type == PKTempTableType.PK_LONG && !(value instanceof Long) ? (value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(Long.parseLong(value.toString()))) : (type != PKTempTableType.PK_LONG && !(value instanceof String) ? value.toString() : value);
                this.data.add(new Object[]{v});
            }
        }

        public Set<Integer> getColumnOrdinals() {
            return this.columnMetadata.keySet();
        }

        public String getColumnName(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).columnName;
        }

        public int getColumnType(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).columnType;
        }

        public int getPrecision(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).precision;
        }

        public int getScale(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).scale;
        }

        public boolean isAutoIncrement(int index) {
            return false;
        }

        public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
            throw new PKTempTableException("Unsupported method addColumnMetadata.");
        }

        public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale) throws SQLServerException {
            throw new PKTempTableException("Unsupported method addColumnMetadata.");
        }

        public void setTimestampWithTimezoneFormat(String datetimeFormat) {
            throw new PKTempTableException("Unsupported method setTimestampWithTimezoneFormat.");
        }

        public void setTimestampWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
            throw new PKTempTableException("Unsupported method setTimestampWithTimezoneFormat.");
        }

        public void setTimeWithTimezoneFormat(String timeFormat) {
            throw new PKTempTableException("Unsupported method setTimeWithTimezoneFormat.");
        }

        public void setTimeWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
            throw new PKTempTableException("Unsupported method setTimeWithTimezoneFormat.");
        }

        public DateTimeFormatter getColumnDateTimeFormatter(int column) {
            throw new PKTempTableException("Unsupported method getColumnDateTimeFormatter.");
        }

        public Object[] getRowData() {
            if (this.position < 0) {
                throw new RuntimeException("Before getRowData should call next.");
            }
            return this.current;
        }

        public boolean next() {
            ++this.position;
            if (this.position >= this.data.size()) {
                return false;
            }
            this.current = this.data.get(this.position);
            return this.current != null;
        }
    }
}

