/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.pool;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.temptable.pk.pool.PKTempTablePool;
import kd.bos.db.temptable.pk.pool.PKTempTablePoolImpl;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.exception.SecureExceptionUtil;

public final class PKTempTablePoolFactory {
    private static final Map<String, String> sharingKeyMap = new ConcurrentHashMap<String, String>();
    private static final Map<String, PKTempTablePool> poolMap = new ConcurrentHashMap<String, PKTempTablePool>();

    public static PKTempTablePool getOrCreatePool(DBRoute route, PKTempTableType type) {
        RequestContextInfo rc = RequestContextInfo.get();
        String routeKey = type.toString() + '#' + route.getRouteKey() + '#' + rc.getTenantId() + '#' + rc.getAccountId();
        String sharingKey = sharingKeyMap.computeIfAbsent(routeKey, k -> {
            try (DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(route.getRouteKey(), false);){
                String string = con.getDBConfig().getSharingId();
                return string;
            }
            catch (SQLException e) {
                throw SecureExceptionUtil.wrapSQLException((SQLException)e);
            }
        });
        String poolKey = type.toString() + '#' + sharingKey;
        return poolMap.computeIfAbsent(poolKey, k -> new PKTempTablePoolImpl(rc, route, type));
    }

    public static List<PKTempTablePool> getPools() {
        return new ArrayList<PKTempTablePool>(poolMap.values());
    }
}

