/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.temptable.pk.pool.PKTempTablePool;
import kd.bos.db.temptable.pk.pool.PKTempTablePoolConfig;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObject;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObjectFactory;
import kd.bos.db.temptable.pk.stats.PKTempTableStats;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.exception.ExceptionUtil;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

final class PKTempTablePoolImpl
implements PKTempTablePool {
    private static final Log log = LogFactory.getLog((String)"DB");
    private final GenericObjectPool<PKTempTablePooledObject> tempTablePool;
    private final Map<String, PKTempTablePooledObject> objMap = new ConcurrentHashMap<String, PKTempTablePooledObject>();
    private final PKTempTablePooledObjectFactory objectFactory;

    PKTempTablePoolImpl(RequestContextInfo rc, DBRoute route, PKTempTableType type) {
        this.objectFactory = new PKTempTablePooledObjectFactory(rc, route, type);
        this.tempTablePool = new GenericObjectPool((PooledObjectFactory)this.objectFactory, PKTempTablePoolConfig.toGenericObjectPoolConfig());
        try {
            this.tempTablePool.preparePool();
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }

    @Override
    public String borrowTable() {
        try {
            PKTempTablePooledObject borrowObject = (PKTempTablePooledObject)this.tempTablePool.borrowObject();
            String table = borrowObject.getTable();
            this.objMap.put(table, borrowObject);
            PKTempTableStats.incBorrowed();
            return table;
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((String)"Borrow pkTempTable failed.", (Throwable)e);
        }
    }

    @Override
    public void returnTable(String table) {
        PKTempTablePooledObject tempTableObject = this.objMap.remove(table);
        if (tempTableObject != null) {
            this.tempTablePool.returnObject((Object)tempTableObject);
        }
    }

    @Override
    public void destoryTable(String table) {
        PKTempTablePooledObject tempTableObject = this.objMap.remove(table);
        if (tempTableObject != null) {
            try {
                this.tempTablePool.invalidateObject((Object)tempTableObject);
            }
            catch (Exception e) {
                log.error("destoryTable pktemptable " + table + " error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public int getActiveNum() {
        return this.tempTablePool.getNumActive();
    }

    @Override
    public int getTotalNum() {
        return this.tempTablePool.getNumActive() + this.tempTablePool.getNumIdle();
    }
}

