/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.registry.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.temptable.pk.PKTempTableUtil;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObject;
import kd.bos.db.temptable.pk.registry.db.DBInstanceTable;
import kd.bos.dc.api.model.Account;
import kd.bos.util.DisCardUtil;

public class DBInstanceClear {
    private Account account;
    private Map<String, List<PKTempTablePooledObject>> instanceMapTableObjects = new HashMap<String, List<PKTempTablePooledObject>>();

    public DBInstanceClear(Account account) {
        this.account = account;
    }

    public void putInstancesObjects(String instanceId, List<PKTempTablePooledObject> objects) {
        if (objects == null) {
            objects = Collections.emptyList();
        }
        if (!this.instanceMapTableObjects.containsKey(instanceId)) {
            this.instanceMapTableObjects.put(instanceId, new ArrayList<PKTempTablePooledObject>(objects));
        } else {
            this.instanceMapTableObjects.get(instanceId).addAll(objects);
        }
    }

    public void clear() {
        if (this.instanceMapTableObjects.isEmpty()) {
            return;
        }
        this.instanceMapTableObjects.forEach((instanceId, pkTempTableObjects) -> {
            for (PKTempTablePooledObject obj : pkTempTableObjects) {
                try {
                    AutoCloseable ac = obj.getRequestContextInfo().setupThreadRequestContext();
                    Throwable throwable = null;
                    try {
                        PKTempTableUtil.dropPKTable(obj.getTable(), obj.getRoute());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ac == null) continue;
                        if (throwable != null) {
                            try {
                                ac.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ac.close();
                    }
                }
                catch (Exception ignored) {
                    DisCardUtil.discard();
                }
            }
            DBInstanceTable.removeInstance(this.account, instanceId);
        });
    }

    public Map<String, List<PKTempTablePooledObject>> getInstanceMapTableObjects() {
        return this.instanceMapTableObjects;
    }

    public void removeOnlineInstance(Set<String> crashInstanceIds) {
        HashSet<String> onlineInstanceIds = new HashSet<String>(crashInstanceIds.size());
        for (Map.Entry<String, List<PKTempTablePooledObject>> entry : this.instanceMapTableObjects.entrySet()) {
            if (crashInstanceIds.contains(entry.getKey())) continue;
            onlineInstanceIds.add(entry.getKey());
        }
        for (String onlineInstanceId : onlineInstanceIds) {
            this.instanceMapTableObjects.remove(onlineInstanceId);
        }
    }

    public boolean hasCrashNode() {
        return !this.instanceMapTableObjects.isEmpty();
    }
}

