/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.registry.db;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.temptable.pk.PKTempTableAccountUtils;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObject;
import kd.bos.db.temptable.pk.registry.PKTempTableRegistry;
import kd.bos.db.temptable.pk.registry.db.DBInstanceClear;
import kd.bos.db.temptable.pk.registry.db.DBInstanceTable;
import kd.bos.db.temptable.pk.registry.db.DBRegistryInstanceHeartbeat;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class PKTempTableDBRegistry
implements PKTempTableRegistry {
    public static final String SUFFIX_DELIM = "_";
    private static final String ERROR_SUFFIX = "ERROR";
    private static volatile PKTempTableDBRegistry INSTANCE;
    private static final Log log;
    private static final Map<String, String> accountSuffixMap;
    private static final Map<String, String> accountRegistErrorMessageMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PKTempTableDBRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<PKTempTableDBRegistry> clazz = PKTempTableDBRegistry.class;
        synchronized (PKTempTableDBRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new PKTempTableDBRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private PKTempTableDBRegistry() {
        if (PKTempTableConfig.getRegistryType() == PKTempTableRegistry.RegistryType.db) {
            List<Account> accountList = PKTempTableAccountUtils.getAllAccountsOfCurrentEnv();
            for (Account account : accountList) {
                this.registInstanceTableNameSuffix(account);
            }
        }
    }

    private String registInstanceTableNameSuffix(Account account) {
        String suffix = SUFFIX_DELIM + DBInstanceTable.addCurrentInstance(account);
        String accountKey = account.getTenantId() + '#' + account.getAccountId();
        if (suffix.length() > SUFFIX_DELIM.length() + 6) {
            accountRegistErrorMessageMap.put(accountKey, suffix);
            suffix = ERROR_SUFFIX;
        }
        accountSuffixMap.put(accountKey, suffix);
        return suffix;
    }

    @Override
    public String getTableNameSuffix() {
        RequestContextInfo rc = RequestContextInfo.get();
        String accountKey = rc.getTenantId() + '#' + rc.getAccountId();
        String suffix = accountSuffixMap.get(accountKey);
        if (ERROR_SUFFIX.equals(suffix) && ERROR_SUFFIX.equals(suffix = this.registInstanceTableNameSuffix(AccountUtils.getAccountById(rc.getAccountId())))) {
            throw new RuntimeException("PKTempTableDBRegistry getTableNameSuffix failed: " + accountRegistErrorMessageMap.get(accountKey));
        }
        return suffix;
    }

    @Override
    public void regist(PKTempTablePooledObject pkTempTable) {
    }

    @Override
    public void unRegist(PKTempTablePooledObject pkTempTable) {
    }

    @Override
    public List<String> getRegistInstances() throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        List<Account> accountList = PKTempTableAccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accountList) {
            ret.addAll(DBInstanceTable.getInstances(account));
        }
        return ret;
    }

    @Override
    public List<PKTempTablePooledObject> getRegistPKTempTables(String instanceId) {
        ArrayList<PKTempTablePooledObject> ret = new ArrayList<PKTempTablePooledObject>();
        List<Account> accountList = PKTempTableAccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accountList) {
            ret.addAll(DBInstanceTable.getInstanceExistsPKTempTable(account, instanceId));
        }
        return ret;
    }

    @Override
    public void unRegistInstance(String instanceId) {
        List<Account> accountList = PKTempTableAccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accountList) {
            DBInstanceTable.removeInstance(account, instanceId);
        }
    }

    @Override
    public void heartbeat() {
        List<Account> accountList = PKTempTableAccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accountList) {
            DBInstanceTable.updateInstanceHeartbeatTime(account);
        }
    }

    public List<DBInstanceClear> getCrashInstancesClear() {
        int timeoutMinute = this.checkAndGetTimeOutMinute();
        List<Account> accountList = PKTempTableAccountUtils.getAllAccountsOfCurrentEnv();
        LinkedList<DBInstanceClear> allDBInstance = new LinkedList<DBInstanceClear>();
        HashMap<String, LocalDateTime> instanceLastHeartbeatTime = new HashMap<String, LocalDateTime>();
        for (Account account : accountList) {
            List<DBRegistryInstanceHeartbeat> instances = DBInstanceTable.getDBRegistryInstances(account);
            for (DBRegistryInstanceHeartbeat instance : instances) {
                LocalDateTime currentAccountLastHeartbeatTime = instance.getLastHeartbeatTime();
                if (currentAccountLastHeartbeatTime == null) {
                    log.warn("Instance: " + instance.getInstanceId() + " get lastHeartbeatTime is null");
                    if (!PKTempTableConfig.isClearOldDBRegistryInstance()) continue;
                    currentAccountLastHeartbeatTime = LocalDateTime.now().plusMinutes((timeoutMinute + 10) * -1);
                }
                List<PKTempTablePooledObject> objs = DBInstanceTable.getInstanceExistsPKTempTable(account, instance.getInstanceId());
                DBInstanceClear clear = new DBInstanceClear(account);
                clear.putInstancesObjects(instance.getInstanceId(), objs);
                allDBInstance.add(clear);
                LocalDateTime lastHeartbeatTime = (LocalDateTime)instanceLastHeartbeatTime.get(instance.getInstanceId());
                if (lastHeartbeatTime == null) {
                    instanceLastHeartbeatTime.put(instance.getInstanceId(), currentAccountLastHeartbeatTime);
                    continue;
                }
                if (!currentAccountLastHeartbeatTime.isAfter(lastHeartbeatTime)) continue;
                instanceLastHeartbeatTime.put(instance.getInstanceId(), currentAccountLastHeartbeatTime);
            }
        }
        HashSet<String> crashInstanceIds = new HashSet<String>(instanceLastHeartbeatTime.size());
        LocalDateTime timeout = LocalDateTime.now().plusMinutes(timeoutMinute * -1);
        instanceLastHeartbeatTime.forEach((k, v) -> {
            if (v.isBefore(timeout)) {
                crashInstanceIds.add((String)k);
            }
        });
        if (crashInstanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DBInstanceClear> result = new ArrayList<DBInstanceClear>(allDBInstance.size());
        for (DBInstanceClear item : allDBInstance) {
            item.removeOnlineInstance(crashInstanceIds);
            if (!item.hasCrashNode()) continue;
            result.add(item);
        }
        return result;
    }

    private int checkAndGetTimeOutMinute() {
        int timeoutMinute = PKTempTableConfig.getHeartbeatMinute() * PKTempTableConfig.getTimeoutCycleInterval();
        if (timeoutMinute <= 0) {
            throw new RuntimeException("PKTempConfig error,heartbeatMinute=" + PKTempTableConfig.getHeartbeatMinute() + ",timeoutCycleInterval=" + PKTempTableConfig.getTimeoutCycleInterval());
        }
        return timeoutMinute;
    }

    static {
        log = LogFactory.getLog(PKTempTableDBRegistry.class);
        accountSuffixMap = new ConcurrentHashMap<String, String>();
        accountRegistErrorMessageMap = new ConcurrentHashMap<String, String>();
    }
}

