/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.table;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.temptable.pk.PKTempTable;
import kd.bos.db.temptable.pk.PKTempTableReleaseListener;

abstract class AbstractPKTempTable
implements PKTempTable {
    private long msTo;
    private long msTimeout;
    private final List<PKTempTableReleaseListener> rls = new ArrayList<PKTempTableReleaseListener>(2);
    protected AtomicBoolean released = new AtomicBoolean();

    AbstractPKTempTable() {
    }

    @Override
    public final long getTimeout() {
        return this.msTimeout;
    }

    @Override
    public final void setTimeout(long msTimeout) {
        this.msTimeout = msTimeout;
        this.msTo = msTimeout + System.currentTimeMillis();
    }

    @Override
    public final long getTimeoutRemaining() {
        return this.msTo - System.currentTimeMillis();
    }

    @Override
    public final boolean isTimeout() {
        return this.msTo < System.currentTimeMillis();
    }

    @Override
    public final boolean isReleased() {
        return this.released.get();
    }

    protected final void checkReleasedOrTimeout() {
        if (this.isReleased()) {
            throw new IllegalStateException("PKTempTable " + this.getTable() + " has released!");
        }
        if (this.isTimeout()) {
            throw new IllegalStateException("PKTempTable " + this.getTable() + " timeout, remaining " + this.getTimeoutRemaining() + "ms.");
        }
    }

    @Override
    public void addReleaseListener(PKTempTableReleaseListener rl) {
        this.rls.add(rl);
    }

    protected void fireReleased() {
        for (PKTempTableReleaseListener rl : this.rls) {
            rl.onReleased();
        }
    }

    protected abstract void destoryOnTimeout();
}

