/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.table;

import java.util.Collection;
import kd.bos.db.DBRoute;
import kd.bos.db.temptable.pk.PKTempTableUtil;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.pool.PKTempTablePool;
import kd.bos.db.temptable.pk.pool.PKTempTablePoolFactory;
import kd.bos.db.temptable.pk.table.AbstractPKTempTable;
import kd.bos.db.temptable.pk.table.PKTempTableReleaser;
import kd.bos.db.temptable.pk.table.PKTempTableTimeoutChecker;
import kd.bos.db.temptable.pk.table.PKTempTableType;

final class PKTempTablePoolObject
extends AbstractPKTempTable {
    private final DBRoute route;
    private final String table;
    private final PKTempTablePool pool;

    PKTempTablePoolObject(DBRoute route, PKTempTableType type) {
        this.route = route;
        this.pool = PKTempTablePoolFactory.getOrCreatePool(route, type);
        this.table = this.pool.borrowTable();
        this.setTimeout((long)PKTempTableConfig.getTimeoutMinute() * 60000L);
        PKTempTableTimeoutChecker.addForCheck(this);
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void insert(Collection<? extends Object> pks) {
        this.checkReleasedOrTimeout();
        PKTempTableUtil.insertPKs(this.route, this.table, pks);
    }

    @Override
    public void clear() {
        this.checkReleasedOrTimeout();
        PKTempTableUtil.truncateTable(this.route, this.table);
    }

    @Override
    public void release() {
        if (this.released.compareAndSet(false, true)) {
            PKTempTableReleaser.release(new PKTempTableReleaser.ReleaseAction(){

                @Override
                public void release() {
                    try {
                        try {
                            PKTempTableUtil.truncateTable(PKTempTablePoolObject.this.route, PKTempTablePoolObject.this.table);
                            PKTempTablePoolObject.this.pool.returnTable(PKTempTablePoolObject.this.table);
                        }
                        catch (Exception ignored) {
                            PKTempTablePoolObject.this.pool.destoryTable(PKTempTablePoolObject.this.table);
                        }
                    }
                    finally {
                        PKTempTablePoolObject.this.fireReleased();
                    }
                }

                @Override
                public String toString() {
                    return PKTempTablePoolObject.this.table + '@' + PKTempTablePoolObject.this.route;
                }
            });
        }
    }

    @Override
    protected void destoryOnTimeout() {
        this.pool.destoryTable(this.table);
    }

    public String toString() {
        return this.table + '@' + this.route;
    }
}

