/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.table;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.db.pktemptable.utils.PKTempTableThreadUtils;
import kd.bos.db.temptable.pk.PKTempTable;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.stats.PKTempTableStats;
import kd.bos.db.temptable.pk.table.AbstractPKTempTable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;

class PKTempTableTimeoutChecker {
    private static final Log log = LogFactory.getLog((String)"DB");
    private static final Object lock = new Object();
    private static final List<PKTempTable> checkList = new LinkedList<PKTempTable>();
    private static final Thread checkThread;

    PKTempTableTimeoutChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runCheckTimeout() {
        try {
            while (!Thread.interrupted()) {
                ArrayList<PKTempTable> checkListBuf;
                PKTempTableThreadUtils.resetThread();
                long ts = (long)PKTempTableConfig.getTimeoutMinute() * 60000L;
                long minWait = -1L;
                Object object = lock;
                synchronized (object) {
                    checkListBuf = new ArrayList<PKTempTable>(checkList);
                }
                for (PKTempTable tt : checkListBuf) {
                    if (tt.isReleased()) {
                        PKTempTableTimeoutChecker.remove(tt);
                        continue;
                    }
                    if (tt.isTimeout()) {
                        try {
                            ((AbstractPKTempTable)tt).destoryOnTimeout();
                            continue;
                        }
                        catch (Exception e) {
                            log.error("timeout destory table " + tt + " error: " + e.getMessage());
                            continue;
                        }
                        finally {
                            PKTempTableTimeoutChecker.remove(tt);
                            PKTempTableStats.incTimeout();
                            continue;
                        }
                    }
                    if (minWait == -1L) {
                        minWait = tt.getTimeoutRemaining();
                        continue;
                    }
                    minWait = Math.min(minWait, tt.getTimeoutRemaining());
                }
                object = lock;
                synchronized (object) {
                    if (checkList.isEmpty()) {
                        lock.wait(ts);
                    } else {
                        minWait = minWait < 10000L ? 10000L : minWait;
                        lock.wait(minWait);
                    }
                }
            }
            return;
        }
        catch (InterruptedException e) {
            log.warn("thread of timeout check is interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addForCheck(PKTempTable tt) {
        Object object = lock;
        synchronized (object) {
            checkList.add(tt);
            PKTempTableStats.incUncheck();
            tt.addReleaseListener(() -> PKTempTableTimeoutChecker.remove(tt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(PKTempTable tt) {
        Object object = lock;
        synchronized (object) {
            boolean remove = checkList.remove(tt);
            if (remove) {
                PKTempTableStats.decUncheck();
            }
        }
    }

    static {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PKTempTableTimeoutChecker.runCheckTimeout();
            }
        };
        checkThread = new Thread(ThreadLifeCycleManager.wrapRunnable((Runnable)r));
        checkThread.setDaemon(true);
        checkThread.setName(PKTempTableTimeoutChecker.class.getSimpleName());
        checkThread.start();
    }
}

