/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.table;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.temptable.pk.PKTempTableUtil;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObject;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObjectFactory;
import kd.bos.db.temptable.pk.stats.PKTempTableStats;
import kd.bos.db.temptable.pk.table.AbstractPKTempTable;
import kd.bos.db.temptable.pk.table.PKTempTableReleaser;
import kd.bos.db.temptable.pk.table.PKTempTableTimeoutChecker;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleListener;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.exception.ExceptionUtil;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;

final class PKTempTableUnPoolObject
extends AbstractPKTempTable {
    private static final Log log = LogFactory.getLog((String)"DB");
    private static Map<String, PooledObjectFactory<PKTempTablePooledObject>> objFactoryMap = new ConcurrentHashMap<String, PooledObjectFactory<PKTempTablePooledObject>>();
    private static final ThreadLocal<Set<PKTempTableUnPoolObject>> TEMP_TABLE_THREAD_RESOURCE = ThreadLocals.create(HashSet::new);
    private final DBRoute route;
    private final PKTempTableType type;
    private final PooledObject<PKTempTablePooledObject> tableObject;
    private final RequestContextInfo rc = RequestContextInfo.get();

    private static PooledObjectFactory<PKTempTablePooledObject> getPooledObjectFactory(RequestContextInfo rc, DBRoute route, PKTempTableType type) {
        String factoryKey = type.toString() + '#' + route.getRouteKey() + '#' + rc.getTenantId() + '#' + rc.getAccountId();
        return objFactoryMap.computeIfAbsent(factoryKey, k -> new PKTempTablePooledObjectFactory(rc, route, type));
    }

    PKTempTableUnPoolObject(DBRoute route, PKTempTableType type) {
        this.route = route;
        this.type = type;
        try {
            this.tableObject = PKTempTableUnPoolObject.getPooledObjectFactory(this.rc, route, type).makeObject();
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
        this.setTimeout((long)PKTempTableConfig.getTimeoutMinute() * 60000L);
        PKTempTableTimeoutChecker.addForCheck(this);
        PKTempTableStats.incBorrowed();
        TEMP_TABLE_THREAD_RESOURCE.get().add(this);
    }

    @Override
    public String getTable() {
        return ((PKTempTablePooledObject)this.tableObject.getObject()).getTable();
    }

    @Override
    public void insert(Collection<? extends Object> pks) {
        this.checkReleasedOrTimeout();
        PKTempTableUtil.insertPKs(this.route, ((PKTempTablePooledObject)this.tableObject.getObject()).getTable(), pks);
    }

    @Override
    public void clear() {
        this.checkReleasedOrTimeout();
        PKTempTableUtil.truncateTable(this.route, ((PKTempTablePooledObject)this.tableObject.getObject()).getTable());
    }

    @Override
    public void release() {
        if (this.released.compareAndSet(false, true)) {
            PKTempTableReleaser.release(new PKTempTableReleaser.ReleaseAction(){

                @Override
                public void release() {
                    try {
                        PKTempTableUnPoolObject.getPooledObjectFactory(PKTempTableUnPoolObject.this.rc, PKTempTableUnPoolObject.this.route, PKTempTableUnPoolObject.this.type).destroyObject(PKTempTableUnPoolObject.this.tableObject);
                    }
                    catch (Exception e) {
                        log.error("release pktemptable " + PKTempTableUnPoolObject.this.tableObject + " error: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        PKTempTableUnPoolObject.this.fireReleased();
                    }
                }

                @Override
                public String toString() {
                    return PKTempTableUnPoolObject.this.tableObject.toString();
                }
            });
        }
    }

    @Override
    protected void destoryOnTimeout() {
        try {
            PKTempTableUnPoolObject.getPooledObjectFactory(this.rc, this.route, this.type).destroyObject(this.tableObject);
        }
        catch (Exception e) {
            log.error("destoryOnTimeout pktemptable " + this.tableObject + " error: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        ThreadLifeCycleManager.addListener((ThreadLifeCycleListener)new ThreadLifeCycleListener(){

            public void start() {
            }

            public void end() {
                try {
                    for (PKTempTableUnPoolObject pkTempTableUnPoolObject : (Set)TEMP_TABLE_THREAD_RESOURCE.get()) {
                        try {
                            pkTempTableUnPoolObject.release();
                        }
                        catch (Exception exception) {}
                    }
                    TEMP_TABLE_THREAD_RESOURCE.remove();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

