/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.protocol.Protocol;

public class ConnectionOptimizer {
    private static final Log log = LogFactory.getLog((String)"DB");
    private static boolean skipMoreResults = true;
    private static Method getProtocol;

    public static void skipMoreResults(Connection con, DBType dbType) throws SQLException {
        if (skipMoreResults && DBType.mysql == dbType && DataSourceURLs.isUseMariaDbDriver()) {
            MariaDbConnection mcon = con.unwrap(MariaDbConnection.class);
            try {
                Protocol p = (Protocol)getProtocol.invoke((Object)mcon, new Object[0]);
                p.skip();
            }
            catch (Exception e) {
                log.warn("DB skipMoreResults error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        ConfigurationUtil.observeBoolean((String)"db.skipMoreResults", (boolean)skipMoreResults, v -> {
            skipMoreResults = v;
        });
        try {
            getProtocol = MariaDbConnection.class.getDeclaredMethod("getProtocol", new Class[0]);
            getProtocol.setAccessible(true);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }
}

