/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import kd.bos.bundle.Resources;
import kd.bos.cache.ThreadCache;
import kd.bos.db.DB;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.WriteArchiveContext;
import kd.bos.db.datasource.DataSourceInfoProvider;
import kd.bos.db.dbsystem.DBSystem;
import kd.bos.db.splittingread.SplittingReadConfig;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.CrossMicroServiceNodeTransactionException;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.DtxHandler;
import kd.bos.db.tx.DtxHandlerFactory;
import kd.bos.db.tx.MockAloneContexts;
import kd.bos.db.tx.Pair;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TXContext;
import kd.bos.db.tx.TXHandle;
import kd.bos.db.tx.TXStat;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.ksql.extension.KSQLExtensionsRegister;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.transaction.XDBTransactionHook;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class TX {
    @SdkInternal
    public static final String IMPLICIT_TRANSACTION_TAG = "Implicit-transaction";
    @SdkInternal
    public static final String MOCKALONE_TRANSACTION_TAG = "Alone-transaction";
    private static final String NONAME_TRANSACTION_TAG = "noname";
    private static final ThreadLocal<Throwable> thException = ThreadLocals.create();
    private static final ThreadLocal<TXContext> tx_holder = new ThreadLocal();
    private static final ThreadLocal<TXContext> out_tx_holder = ThreadLocals.create();
    private static final ThreadLocal<MockAloneContexts> mockalone_tx_holder = ThreadLocals.create(() -> new MockAloneContexts());
    private static final ThreadLocal<Boolean> th_cross_caller_has_transaction = new ThreadLocal();
    private static DataSourceInfoProvider dsProvider = new DataSourceInfoProvider(){};
    private static final String CHECK_CROSS_TRANS = "db.check_cross_trans";
    private static boolean checkCrossTrans = false;
    private static final String[] empty_strings;

    @SdkInternal
    public static void __setDataSourceProvider(DataSourceInfoProvider dsProvider) {
        TX.dsProvider = dsProvider;
    }

    @Deprecated
    @SdkInternal
    public static Connection getConnection(String routeKey, boolean requestForReadOnly) {
        DelegateConnection con = (DelegateConnection)TX.__getConnection(routeKey, requestForReadOnly);
        try {
            con.__setAutoCommit(false);
        }
        catch (SQLException e) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)e);
        }
        return con;
    }

    @Deprecated
    @SdkInternal
    public static Connection getConnection(String routeKey, boolean requestForReadOnly, String ... useTables) {
        DelegateConnection con = (DelegateConnection)TX.__getConnection(routeKey, requestForReadOnly, useTables);
        try {
            con.__setAutoCommit(false);
        }
        catch (SQLException e) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)e);
        }
        return con;
    }

    @Deprecated
    @SdkInternal
    public static Connection getConnection(String routeKey, boolean requestForReadOnly, String mainTable, String ... useTables) {
        DelegateConnection con = (DelegateConnection)TX.__getConnection(routeKey, requestForReadOnly, mainTable, useTables);
        try {
            con.__setAutoCommit(false);
        }
        catch (SQLException e) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)e);
        }
        return con;
    }

    @SdkInternal
    public static Connection __getConnectionSkipWriteArchiveCheck(String routeKey, boolean requestForReadOnly) {
        try (WriteArchiveContext ctx = WriteArchiveContext.create(routeKey);){
            Connection connection = TX.__getConnection(routeKey, requestForReadOnly, empty_strings);
            return connection;
        }
    }

    @SdkInternal
    public static Connection __getConnection(String routeKey, boolean requestForReadOnly) {
        return TX.__getConnection(routeKey, requestForReadOnly, empty_strings);
    }

    @SdkInternal
    public static Connection __getConnection(String routeKey, boolean requestForReadOnly, String ... useTables) {
        if (useTables != null && useTables.length > 0) {
            return TX.__getConnection(routeKey, requestForReadOnly, useTables[0], useTables);
        }
        return TX.__getConnection(routeKey, requestForReadOnly, null, useTables);
    }

    @SdkInternal
    public static Connection __getConnection(String routeKey, boolean requestForReadOnly, String mainTable, String ... useTables) {
        RequestContextInfo rc = RequestContextInfo.get();
        String accountId = rc.getAccountId();
        TXContext ctx = TX.getCurrentOrCreateImplicitTXContext();
        if (ThreadCache.get((Object)"dbSystemInit") == null) {
            DBSystem.ensureInited(accountId);
        }
        DelegateConnection con = ctx.getConnection(rc.getTenantId(), routeKey, accountId, requestForReadOnly, ThreadReadWriteContext.getCurrentSplittingReadWriteMode(), dsProvider, mainTable, useTables);
        try {
            if (ctx.isInTX() && con.getAutoCommit()) {
                con.__setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)e);
        }
        return KSQLExtensionsRegister.handleDelegateConnectionAfterInit((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public static Connection __getAloneConnection(String routeKey, boolean requestForReadOnly, String mainTable, String ... useTables) {
        TXContext mockCTX = new TXContext(Propagation.NOT_SUPPORTED, null, MOCKALONE_TRANSACTION_TAG, true);
        RequestContextInfo rc = RequestContextInfo.get();
        String accountId = rc.getAccountId();
        try {
            Connection connection = KSQLExtensionsRegister.handleDelegateConnectionAfterInit((Connection)mockCTX.getConnection(rc.getTenantId(), routeKey, accountId, requestForReadOnly, ThreadReadWriteContext.getCurrentSplittingReadWriteMode(), dsProvider, mainTable, useTables));
            return connection;
        }
        finally {
            mockalone_tx_holder.get().add(mockCTX);
        }
    }

    private static TXContext getCurrentOrCreateImplicitTXContext() {
        TXContext ctx = tx_holder.get();
        if (ctx == null && (ctx = out_tx_holder.get()) == null) {
            ctx = new TXContext(Propagation.NOT_SUPPORTED, null, IMPLICIT_TRANSACTION_TAG, true);
            out_tx_holder.set(ctx);
        }
        return ctx;
    }

    @SdkInternal
    public static boolean __canQueryOnReadOnlyDB(String tenantId, String routeKey, String accountId, String ... useTables) {
        if (SplittingReadConfig.isSplittingReadEnable()) {
            return TX.getCurrentOrCreateImplicitTXContext().canQueryOnReadOnlyDB(tenantId, routeKey, accountId, dsProvider, useTables);
        }
        return false;
    }

    @SdkInternal
    public static void __setRouteForceMaster(String routeKey) {
        try (DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(routeKey, false);){
            String rw_routeKey = con.getDBConfig().getRouteKey();
            TX.getCurrentOrCreateImplicitTXContext().setRouteForceMaster(rw_routeKey);
        }
        catch (SQLException e) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)e);
        }
    }

    @Deprecated
    @SdkInternal
    public static void begin() {
        TX.beginRequired();
    }

    @Deprecated
    @SdkInternal
    public static TXHandle beginNew() {
        return TX.beginNew(NONAME_TRANSACTION_TAG);
    }

    @Deprecated
    @SdkInternal
    public static TXHandle beginNew(String tag) {
        return TX.declareBegin(Propagation.REQUIRES_NEW, tag);
    }

    @SdkInternal
    public static TXHandle requiresNew() {
        return TX.requiresNew(NONAME_TRANSACTION_TAG);
    }

    public static TXHandle requiresNew(String tag) {
        return TX.declareBegin(Propagation.REQUIRES_NEW, tag);
    }

    @Deprecated
    @SdkInternal
    public static TXHandle beginRequired() {
        return TX.beginRequired(NONAME_TRANSACTION_TAG);
    }

    @Deprecated
    @SdkInternal
    public static TXHandle beginRequired(String tag) {
        return TX.declareBegin(Propagation.REQUIRED, tag);
    }

    @SdkInternal
    public static TXHandle required() {
        return TX.required(NONAME_TRANSACTION_TAG);
    }

    public static TXHandle required(String tag) {
        return TX.declareBegin(Propagation.REQUIRED, tag);
    }

    @Deprecated
    @SdkInternal
    public static TXHandle beginNotSupported() {
        return TX.beginNotSupported(NONAME_TRANSACTION_TAG);
    }

    @Deprecated
    @SdkInternal
    public static TXHandle beginNotSupported(String tag) {
        return TX.declareBegin(Propagation.NOT_SUPPORTED, tag);
    }

    @SdkInternal
    public static TXHandle notSupported() {
        return TX.notSupported(NONAME_TRANSACTION_TAG);
    }

    public static TXHandle notSupported(String tag) {
        return TX.declareBegin(Propagation.NOT_SUPPORTED, tag);
    }

    @SdkInternal
    public static TXHandle nested() {
        return TX.nested(NONAME_TRANSACTION_TAG);
    }

    public static TXHandle nested(String tag) {
        return TX.declareBegin(Propagation.NESTED, tag);
    }

    private static TXHandle declareBegin(Propagation propagation, String tag) {
        DtxHandler dtxh;
        DtxHandlerFactory dtxhFactory;
        if (propagation != Propagation.NOT_SUPPORTED && XDBExternal.isNotSupportedAlways()) {
            propagation = Propagation.NOT_SUPPORTED;
        }
        if (checkCrossTrans && propagation == Propagation.REQUIRED && TX.__isCrossCallerHasTransaction()) {
            throw new CrossMicroServiceNodeTransactionException();
        }
        TXContext parent = tx_holder.get();
        if (parent != null) {
            switch (propagation) {
                case NOT_SUPPORTED: {
                    if (parent.propagation() != Propagation.NOT_SUPPORTED) break;
                    parent.incRefCount(tag);
                    return new TXHandle(parent);
                }
                case REQUIRED: 
                case SUPPORTS: {
                    if (parent.propagation() == Propagation.NOT_SUPPORTED) break;
                    parent.incRefCount(tag);
                    return new TXHandle(parent);
                }
            }
        }
        TXContext tc = new TXContext(propagation, parent, tag, false);
        tx_holder.set(tc);
        if (tc.propagation() == Propagation.REQUIRES_NEW && (dtxhFactory = DtxHandlerFactory.get()) != null && (dtxh = dtxhFactory.getDtxHandler()) != null) {
            dtxh.onTXBegin();
            TX.addCommitListener(new CommitListener(){

                @Override
                public void preCommit() {
                    dtxh.onTXCommit();
                }

                @Override
                public void onEnded(boolean rollbacked) {
                    try {
                        if (rollbacked) {
                            dtxh.onTXRollbacked();
                        }
                    }
                    finally {
                        dtxh.onEnded();
                    }
                }
            });
        }
        if (tc == tc.getTransRoot() && DB.isXDBEnable()) {
            if (!XDBTransactionHook.isInited()) {
                XDBTransactionHook.init(() -> {
                    TXContext tx = TX.__getTXContext();
                    if (tx != null) {
                        return tx.__peekTMRoot().id();
                    }
                    return -1L;
                });
            }
            XDBTransactionHook.fireOnBegin();
            TX.addCommitListener(new CommitListener(){

                @Override
                public void onCommitted() {
                    XDBTransactionHook.fireOnBeforeEnd((boolean)false);
                }

                @Override
                public void onRollbacked() {
                    XDBTransactionHook.fireOnBeforeEnd((boolean)true);
                }

                @Override
                public void onEnded(boolean rollbacked) {
                    XDBTransactionHook.fireOnAfterEnd((boolean)rollbacked);
                }
            });
        }
        return new TXHandle(tc);
    }

    @SdkInternal
    public static TXHandle __getTransRootTXHandle() {
        return TX.getCtx().getTransRoot().getHandle();
    }

    @Deprecated
    @SdkInternal
    public static void markRollback() {
        TX.doMarkRollback();
    }

    @SdkInternal
    static void doMarkRollback() {
        TXContext cur = tx_holder.get();
        if (cur != null) {
            cur.setRollback(true);
        }
    }

    @Deprecated
    @SdkInternal
    public static void end() {
        TX.doEnd();
    }

    @SdkInternal
    static void doEnd() {
        TXContext cur = TX.getCtx();
        Pair<TXContext, RuntimeException> ret = cur.end();
        if (ret != null) {
            TXContext parent = ret.getKey();
            if (parent == null) {
                tx_holder.remove();
            } else {
                tx_holder.set(parent);
            }
            if (ret.getValue() != null) {
                throw ret.getValue();
            }
            cur.onEnded();
        }
    }

    @SdkInternal
    public static boolean inTX() {
        return TX.getPropagation() != Propagation.NOT_SUPPORTED;
    }

    public static Propagation getPropagation() {
        TXContext cur = tx_holder.get();
        return cur == null ? Propagation.NOT_SUPPORTED : cur.propagation();
    }

    @SdkInternal
    static TXContext getCtx() {
        TXContext cur = tx_holder.get();
        if (cur == null) {
            throw new IllegalStateException("No transaction exists(ensure call begin before).");
        }
        return cur;
    }

    @SdkInternal
    public static TXContext __getTXContext() {
        TXContext cur = tx_holder.get();
        if (cur == null) {
            cur = out_tx_holder.get();
        }
        return cur;
    }

    @SdkInternal
    public static void checkLeak() {
        TX.checkLeak(TX.getResponseException());
    }

    @SdkInternal
    public static void __checkMultiDBWrited() {
        TX.getCtx().checkMultiDBWrited();
    }

    @SdkInternal
    public static void __setIgnoreCheckThreadGetMaxConnectionCount(boolean b) {
        TXContext.setIgnoreCheckThreadGetMaxConnectionCount(b);
    }

    private static void checkLeak(Throwable throwException) {
        TXContext cur = tx_holder.get();
        if (cur != null) {
            LinkedList<String> txStacks = new LinkedList<String>();
            int count = 0;
            while (cur != null) {
                if (!cur.isImplicitTX()) {
                    ++count;
                    txStacks.add(cur.toString());
                }
                TX.doEnd();
                cur = tx_holder.get();
            }
            tx_holder.remove();
            if (count > 0) {
                String msg = Resources.get((String)"bos-dbengine", (String)"TX_0", (String)"\u68c0\u6d4b\u5230\u4e8b\u52a1\u672aend ", (Object[])new Object[0]) + count + Resources.get((String)"bos-dbengine", (String)"TX_1", (String)"\u6b21:\r\n", (Object[])new Object[0]) + txStacks;
                if (throwException == null) {
                    throw new KDException(BosErrorCode.transactionLeak, new Object[]{msg});
                }
                if (throwException instanceof InvocationTargetException) {
                    throwException = ((InvocationTargetException)throwException).getTargetException();
                }
                throw new KDException(throwException, BosErrorCode.transactionLeak, new Object[]{msg});
            }
        }
    }

    public static void addCommitListener(CommitListener cl) {
        TX.getCtx().addCommitListener(cl);
    }

    @SdkInternal
    public static Throwable getResponseException() {
        return thException.get();
    }

    @SdkInternal
    public static void setResponseException(Throwable responseException) {
        thException.set(responseException);
    }

    @SdkInternal
    public static TXStat getStat() {
        return TX.getCtx().getStat();
    }

    @SdkInternal
    public static String getWrittenRouteKey() {
        TXContext cur = tx_holder.get();
        return cur == null ? null : cur.getWrittenRouteKey();
    }

    @SdkInternal
    public static void __setCrossCallerHasTransaction(boolean b) {
        th_cross_caller_has_transaction.set(b);
    }

    @SdkInternal
    public static boolean __isCrossCallerHasTransaction() {
        Boolean b = th_cross_caller_has_transaction.get();
        return b != null && b != false;
    }

    static {
        ConfigurationUtil.observeBoolean((String)CHECK_CROSS_TRANS, (boolean)checkCrossTrans, b -> {
            checkCrossTrans = b;
        });
        empty_strings = new String[0];
    }
}

