/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.db.pktemptable.utils.DiscardUtil;
import kd.bos.db.sql.visitor.TXImplicitDecisionVisitor;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TXContext;
import kd.bos.db.tx.TXImplicitHint;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.util.LRUCacheMap;

public class TXImplicitObject {
    private static final Log log = LogFactory.getLog((String)TXImplicitObject.class.getName());
    public static boolean PGDecreaseImplicitTXEnable = ConfigurationUtil.getBoolean((String)"db.tx.pg.implicitEnable", (Boolean)true);
    private static long selectFieldCount = 5L;
    private static long topCount = 5000L;
    private static int cacheSqlLen = 4096;
    private List<ImplicitObject> implicitReferenceList = new ArrayList<ImplicitObject>();
    private static final ThreadLocal<Map<String, Boolean>> sqlCacheCtx;

    public boolean enableImplicit() {
        return !this.implicitReferenceList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImplicitObject handleImplicitTransaction(String sql, DelegateConnection con) {
        if (TXImplicitObject.enablePGDecreaseImplicitTX(con)) {
            try {
                boolean implicit;
                if (sql.length() > cacheSqlLen) {
                    implicit = TXImplicitDecisionVisitor.needEnableImplicit(sql, selectFieldCount, topCount);
                } else {
                    Boolean cache = sqlCacheCtx.get().get(sql);
                    if (cache == null) {
                        cache = TXImplicitDecisionVisitor.needEnableImplicit(sql, selectFieldCount, topCount);
                        sqlCacheCtx.get().put(sql, cache);
                    }
                    implicit = cache;
                }
                if (implicit) {
                    ImplicitObject implicitObject = new ImplicitObject(this);
                    this.implicitReferenceList.add(implicitObject);
                    ImplicitObject implicitObject2 = implicitObject;
                    return implicitObject2;
                }
            }
            catch (Exception e) {
                log.error("DB implicitObject parse sql error:" + e.getMessage(), (Throwable)e);
                DiscardUtil.discard();
            }
            finally {
                try {
                    TXImplicitObject.setImplicitTX(con);
                }
                catch (SQLException ex) {
                    log.error("Set connection auto commit error:" + ex.getMessage(), (Throwable)ex);
                    DiscardUtil.discard();
                }
            }
        }
        return null;
    }

    private static boolean getPGDecreaseImplicitTXEnable() {
        TXImplicitHint hint = TXImplicitHint.getCurrent();
        if (hint != null) {
            return hint.isEnableImplicit();
        }
        return PGDecreaseImplicitTXEnable;
    }

    public static void initConnectSetImplicitOutOfTX(DelegateConnection con) throws SQLException {
        if (TXImplicitObject.enablePGDecreaseImplicitTX(con)) {
            TXImplicitObject.setImplicitTX(con);
        }
        if (TXImplicitObject.getPGDecreaseImplicitTXEnable() && !TXImplicitObject.isPgSeries(con.getDBType()) && !con.inTX() && (con.getCtx().getTag().equalsIgnoreCase("Implicit-transaction") || con.getCtx().getTag().equalsIgnoreCase("Alone-transaction"))) {
            con.getCtx().setImplicitTX(true);
        }
    }

    public static boolean isPgSeries(DBType dbType) {
        return DBType.postgresql == dbType || DBType.kingbase == dbType || dbType == DBType.gaussdb || dbType == DBType.gbase || dbType == DBType.vastbase;
    }

    private static boolean enablePGDecreaseImplicitTX(DelegateConnection connection) {
        return TXImplicitObject.getPGDecreaseImplicitTXEnable() && TXImplicitObject.isPgSeries(connection.getDBType()) && !connection.inTX();
    }

    private static void setImplicitTX(DelegateConnection connection) throws SQLException {
        TXContext txContext = connection.getCtx();
        if (txContext.getImplicitObject().enableImplicit()) {
            txContext.setImplicitTX(true);
            connection.__setAutoCommit(false);
        } else {
            txContext.setImplicitTX(false);
            connection.__setAutoCommit(true);
        }
    }

    static {
        ConfigurationUtil.observeLong((String)"db.tx.pg.implicitSelectFieldCount", (long)selectFieldCount, v -> {
            selectFieldCount = v;
        });
        ConfigurationUtil.observeLong((String)"db.tx.pg.implicitTopCount", (long)topCount, v -> {
            topCount = v;
        });
        ConfigurationUtil.observeInteger((String)"db.tx.pg.implicitCacheSqlLen", (int)cacheSqlLen, v -> {
            cacheSqlLen = v;
        });
        sqlCacheCtx = ThreadLocals.create(() -> new LRUCacheMap(64));
    }

    public static class ImplicitObject {
        private final TXImplicitObject txImplicitObject;

        public ImplicitObject(TXImplicitObject txImplicitObject) {
            this.txImplicitObject = txImplicitObject;
        }

        public void release() {
            this.txImplicitObject.implicitReferenceList.remove(this);
        }
    }
}

