/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.audit.Audit;
import kd.bos.bundle.Resources;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TXContext;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class TXStat {
    private static final String TRACE_TX_NAME = "TX";
    private static final String TRACE_TX_TAG_LEVEL_NAME = "level";
    private static final String TRACE_TX_TAG_DETAIL_NAME = "detail";
    private static final String AUDIT_CONNECTION_COST_NAME = "connection_cost";
    private static final String AUDIT_CONNECTION_HOLDING_NAME = "connection_holding";
    private static final String AUDIT_TX_TIMES_NAME = "tx_times";
    private static final int MAX_HOLD_COUNT = 100;
    private int rootTXCount;
    private int maxRootTXDeep;
    private Map<DelegateConnection, Long> connectionHoldMap = new ConcurrentHashMap<DelegateConnection, Long>();
    private int requestedConnection;
    private int returnedConnection;
    private int _currentTXDeep;
    private LinkedList<Boolean> isRootTXStack = new LinkedList();
    private LinkedList<TraceSpan> rootTraceSpanStack = new LinkedList();

    void enter(long txId, boolean isRootTX) {
        this.isRootTXStack.add(isRootTX);
        if (isRootTX) {
            TraceSpan ts = Tracer.create((String)TRACE_TX_NAME, (String)"enter-exit");
            if (TraceConfig.isTagEnable((String)TRACE_TX_NAME, (String)TRACE_TX_TAG_LEVEL_NAME)) {
                String prefix = "TX-" + (this.rootTraceSpanStack.isEmpty() ? "" : this.rootTraceSpanStack.getLast().getName() + "-");
                ts.addTag(TRACE_TX_TAG_LEVEL_NAME, prefix + txId);
            }
            this.rootTraceSpanStack.add(ts);
            ++this.rootTXCount;
            ++this._currentTXDeep;
            if (this.maxRootTXDeep < this._currentTXDeep) {
                this.maxRootTXDeep = this._currentTXDeep;
            }
        }
    }

    void exit(TXContext tc) {
        if (this.isRootTXStack.removeLast().booleanValue()) {
            --this._currentTXDeep;
            TraceSpan ts = this.rootTraceSpanStack.removeLast();
            if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)TRACE_TX_NAME) && TraceConfig.isTagEnable((String)TRACE_TX_NAME, (String)TRACE_TX_TAG_DETAIL_NAME)) {
                ts.addTag(TRACE_TX_TAG_DETAIL_NAME, tc.toString());
            }
            ts.close();
        }
        if (tc.parent() == null) {
            if (Audit.isEnable((String)AUDIT_CONNECTION_COST_NAME)) {
                Audit.auditDirect((String)AUDIT_CONNECTION_COST_NAME, (int)this.getRequestedConnection(), (long)this.getConnectionHoldTimeMillis(), (long)this.getMaxConnectionHoldTimeMillis(), (Object[])new Object[0]);
            }
            Audit.auditDirect((String)AUDIT_TX_TIMES_NAME, (int)this.getTXCount(), (long)0L, (long)0L, (Object[])new Object[0]);
        }
    }

    void requestConnection(DelegateConnection con) {
        ++this.requestedConnection;
        if (this.connectionHoldMap.size() > 100) {
            for (DelegateConnection dc : new HashSet<DelegateConnection>(this.connectionHoldMap.keySet())) {
                if (!dc.hasCallClosed()) continue;
                this.connectionHoldMap.remove(dc);
            }
            if (this.connectionHoldMap.size() > 100) {
                throw new IllegalStateException(Resources.get((String)"bos-dbengine", (String)"TXStat_0", (String)"\u8fde\u63a5\u4f7f\u7528\u5f02\u5e38\uff1a\u5f53\u524d\u7ebf\u7a0b\u5df2\u6301\u6709", (Object[])new Object[0]) + this.connectionHoldMap.size() + Resources.get((String)"bos-dbengine", (String)"TXStat_1", (String)"\u4e2a\u672a\u5173\u95ed\u7684\u8fde\u63a5\u3002", (Object[])new Object[0]));
            }
        }
        this.connectionHoldMap.put(con, System.currentTimeMillis());
        Audit.auditDirect((String)AUDIT_CONNECTION_HOLDING_NAME, (int)this.getHoldingUnclosedConnectionCount(), (long)0L, (long)0L, (Object[])new Object[0]);
    }

    void returnConnection(DelegateConnection con) {
        ++this.returnedConnection;
        Long ts = this.connectionHoldMap.get(con);
        if (ts != null) {
            this.connectionHoldMap.put(con, System.currentTimeMillis() - ts);
        }
    }

    public int getTXCount() {
        return this.rootTXCount;
    }

    public int getMaxTXDeep() {
        return this.maxRootTXDeep;
    }

    public int getRequestedConnection() {
        return this.requestedConnection;
    }

    public int getReturnedConnection() {
        return this.returnedConnection;
    }

    public long getConnectionHoldTimeMillis() {
        long ts = 0L;
        for (DelegateConnection con : new HashSet<DelegateConnection>(this.connectionHoldMap.keySet())) {
            Long t = this.connectionHoldMap.get(con);
            if (t == null) continue;
            if (!con.hasCallClosed()) {
                t = System.currentTimeMillis() - t;
            }
            ts += t.longValue();
        }
        return ts;
    }

    public long getMaxConnectionHoldTimeMillis() {
        long ts = 0L;
        for (DelegateConnection con : new HashSet<DelegateConnection>(this.connectionHoldMap.keySet())) {
            Long t = this.connectionHoldMap.get(con);
            if (t == null) continue;
            if (!con.hasCallClosed()) {
                t = System.currentTimeMillis() - t;
            }
            if (ts >= t) continue;
            ts = t;
        }
        return ts;
    }

    public int getHoldingUnclosedConnectionCount() {
        int count = 0;
        for (DelegateConnection con : new HashSet<DelegateConnection>(this.connectionHoldMap.keySet())) {
            if (con.hasCallClosed()) continue;
            ++count;
        }
        return count;
    }
}

