/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.api.model;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dc.api.model.DBInstance;

public class Account
implements Serializable {
    private String accountId;
    private String accountName;
    private String accountNumber;
    private boolean isDefault;
    private String version;
    private String eid;
    private String yzjUrl;
    private String ssoPlugin;
    private String yzjWeb;
    private String yzjOrgNo;
    private String userSourceType;
    private String keyFile;
    private String tenantId;
    private String productVersion = "";
    private boolean splittingRead;
    private boolean isdtsenable;
    private String docDomain;
    private List<DBInstance> DBInstanceList = null;

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setDefault(String isD) {
        this.isDefault = false;
        if (isD != null && "true".equalsIgnoreCase(isD)) {
            this.isDefault = true;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEid() {
        return this.eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getYzjUrl() {
        return this.yzjUrl;
    }

    public void setYzjUrl(String yzjUrl) {
        this.yzjUrl = yzjUrl;
    }

    public String getSsoPlugin() {
        return this.ssoPlugin;
    }

    public void setSsoPlugin(String ssoPlugin) {
        this.ssoPlugin = ssoPlugin;
    }

    public String getYzjWeb() {
        return this.yzjWeb;
    }

    public void setYzjWeb(String yzjWeb) {
        this.yzjWeb = yzjWeb;
    }

    public String getYzjOrgNo() {
        return this.yzjOrgNo;
    }

    public void setYzjOrgNo(String yzjOrgNo) {
        this.yzjOrgNo = yzjOrgNo;
    }

    public String getUserSourceTypeOutput() {
        return this.userSourceType;
    }

    public String[] getAllSourceTypes() {
        String tempString;
        String[] args = new String[]{"2"};
        if (this.userSourceType != null && (tempString = this.userSourceType) != null && tempString.trim().length() > 0) {
            tempString = tempString.replace("[", "");
            tempString = tempString.replace("]", "");
            tempString = tempString.replace(" ", "");
            args = tempString.split(",");
        }
        return args;
    }

    public void setUserSourceType(String userSourceType) {
        this.userSourceType = userSourceType;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public List<DBInstance> getDBInstanceList() {
        return this.DBInstanceList;
    }

    public List<DBInstance> getDBInstanceList(boolean readonly) {
        return this.DBInstanceList.stream().filter(i -> i.isReadOnly() == readonly).collect(Collectors.toList());
    }

    public void setDBInstanceList(List<DBInstance> dBInstanceList) {
        this.DBInstanceList = dBInstanceList;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public DBInstance getDefaultDBInstance() {
        DBInstance returnInstance = null;
        DBInstance instanceTmp = null;
        if (this.DBInstanceList != null) {
            for (DBInstance instance : this.DBInstanceList) {
                if ("0".equals(instance.getReadOnly()) && "basedata".equalsIgnoreCase(instance.getRouteKey())) {
                    returnInstance = instance;
                    break;
                }
                if (!"0".equals(instance.getReadOnly()) || !"".equals(instance.getRouteKey()) && !"basedata".equalsIgnoreCase(instance.getRouteKey())) continue;
                instanceTmp = instance;
            }
            if (returnInstance == null) {
                returnInstance = instanceTmp;
            }
        }
        return returnInstance;
    }

    public DBInstance getDBInstanceByRouteKey(String routeKey) {
        DBInstance returnInstance = null;
        if (routeKey != null && this.DBInstanceList != null) {
            for (DBInstance instance : this.DBInstanceList) {
                if (!routeKey.equalsIgnoreCase(instance.getRouteKey())) continue;
                returnInstance = instance;
                break;
            }
        }
        return returnInstance;
    }

    public boolean equals(Object temp) {
        boolean isEquals = false;
        if (this.accountNumber != null && temp instanceof Account && temp != null && this.accountNumber.equals(((Account)temp).accountNumber)) {
            isEquals = true;
        }
        return isEquals;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.accountNumber.hashCode();
        if (this.accountName != null) {
            hash = hash * 31 + this.accountName.hashCode();
        }
        return hash;
    }

    public boolean isSplittingRead() {
        return this.splittingRead;
    }

    public void setSplittingRead(boolean splittingRead) {
        this.splittingRead = splittingRead;
    }

    public boolean isDtsEnable() {
        return this.isdtsenable;
    }

    public void setDtsEnable(boolean isdtsenable) {
        this.isdtsenable = isdtsenable;
    }

    public String getDocDomain() {
        return this.docDomain;
    }

    public void setDocDomain(String docDomain) {
        this.docDomain = docDomain;
    }

    public String toString() {
        return "DataCenter [accountId=" + this.accountId + ", accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ", isDefault=" + this.isDefault + ", version=" + this.version + ", eid=" + this.eid + ", yzjUrl=" + this.yzjUrl + ", ssoPlugin=" + this.ssoPlugin + ", yzjWeb=" + this.yzjWeb + ", yzjOrgNo=" + this.yzjOrgNo + ", userSourceType=" + this.userSourceType + ", keyFile=" + this.keyFile + ", tenantId=" + this.tenantId + ", DBInstanceList=" + this.DBInstanceList + "]";
    }
}

