/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.mc.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBObject;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.mc.TripInfo;
import kd.bos.dc.mc.impl.MCCommon;
import kd.bos.dc.mc.tenant.LptaParameter;
import kd.bos.dc.utils.ClusterUtil;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.File;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.security.PermissionManager;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.DBResources;

public class LoginMCServiceApiImpl
implements LoginMCService {
    private Log logger = LogFactory.getLog(LoginMCServiceApiImpl.class);
    private static final String MC_API_GETSINGLETENANT = "/kapi/app/mc/GetSingleDataCenterInfoService";
    private static final String MC_API_GET_ALLDATACENTER = "/kapi/app/mc/GetDataCenterInfoService";
    private static final String MC_API_GET_SINGLE_DATACENTER = "/login/getdatacenterbyid";
    private static final String MC_API_GET_ALL_TENANTS_BY_CLUSTER_NAME = "/kapi/app/mc/GetTenantInfoService";
    private static final String MC_API_GET_TRIP_INFO = "/kapi/app/mc/GetCtripInfo";
    private static final String MC_API_GETWEBCLIENTFILESSERVICE = "/kapi/app/mc/GetWebClientFilesService";
    private static final String MC_API_WEBCLIENTFILESSAVESERVICE = "/kapi/app/mc/WebClientFilesSaveService";
    private static final String MC_API_GET_MC_DATA = "/kapi/app/mc/DataSaveGetService";
    private static final String MC_API_SET_MC_DATA = "/kapi/app/mc/DataSaveSetService";
    private static final String MC_API_GETGRAYENVIRONMENTINFO = "/kapi/app/mc/getGrayEnvironmentInfo";
    private static final String MC_API_UPDATEGRAYUSERINFO = "/kapi/app/mc/updateGrayUserInfo";
    private static final String MC_API_GETGRAYAPPGROUP = "/kapi/app/mc/getGrayAppGroup";
    private static final String MC_API_UPGRADEGRAYSTRATEGY = " /kapi/app/mc/upgradeGrayStrategy";

    @Override
    public List<TenantInfo> getWholeTenantsByCurrentEnv() {
        PermissionManager.check();
        ArrayList<TenantInfo> list = new ArrayList<TenantInfo>(2);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String clusterName = ClusterUtil.getClusterNameForUsingDataCenter();
        map.put("clusterName", clusterName);
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_GET_ALL_TENANTS_BY_CLUSTER_NAME, true, null, map);
        List lstTenant = (List)obj;
        for (Map t : lstTenant) {
            Object joinImprovement;
            TenantInfo info = new TenantInfo(String.valueOf(t.get("tenantnumber")), String.valueOf(t.get("tenantname")));
            Object instanceNumber = t.get("instancenumber");
            if (Objects.nonNull(instanceNumber)) {
                info.setInstanceNumber(String.valueOf(instanceNumber));
            }
            if (Objects.nonNull(joinImprovement = t.get("joinimprovement"))) {
                info.setJoinImprovement(Boolean.parseBoolean((String)joinImprovement));
            }
            Object createTime = t.get("createtime");
            info.setCreateTime(MCCommon.getLongObject(createTime));
            List versionListList = (List)t.get("firstversion");
            HashMap<String, String> firstVersionMap = new HashMap<String, String>();
            if (versionListList != null) {
                for (Map instanceMap : versionListList) {
                    String productNumber = MCApiUtil.getString(instanceMap.get("productnumber"));
                    String productVersion = MCApiUtil.getString(instanceMap.get("version"));
                    firstVersionMap.put(productNumber, productVersion);
                }
                info.setCreateVersion(firstVersionMap);
            }
            list.add(info);
        }
        return list;
    }

    @Override
    public LptaParameter getLptaParameter(Account currentCenter) {
        PermissionManager.check();
        LptaParameter para = null;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("tenantNumber", currentCenter.getTenantId());
        map.put("sandBoxNumber", Instance.getClusterName());
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_GETSINGLETENANT, true, null, map);
        Map tenant = (Map)obj;
        if (tenant != null) {
            para = new LptaParameter(currentCenter.getTenantId(), (String)tenant.get("secret"), String.valueOf(tenant.get("expiration")), (String)tenant.get("islmbcsencode"));
        }
        return para;
    }

    @Override
    public List<Account> getAllAccounts(String tenantId) {
        List centerList;
        PermissionManager.check();
        ArrayList<Account> returnList = null;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String clusterName = ClusterUtil.getClusterNameForUsingDataCenter();
        map.put("tenantId", tenantId);
        map.put("clusterName", clusterName);
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_GET_ALLDATACENTER, true, null, map);
        if (obj != null && (centerList = (List)obj) != null) {
            returnList = new ArrayList<Account>(2);
            for (Map centerMap : centerList) {
                Account center = MCApiUtil.getAccount(centerMap);
                center.setTenantId(tenantId);
                returnList.add(center);
            }
        }
        return returnList;
    }

    @Override
    public Account getSingleAccount(String accountId, String tenantId) {
        PermissionManager.check();
        Account account = null;
        if (StringUtils.isNotEmpty((String)accountId)) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("dataCenterId", accountId);
            Object obj = MCApiUtil.getMCAPIInfo(MC_API_GET_SINGLE_DATACENTER, true, null, map);
            if (obj != null) {
                Map accountMap = (Map)obj;
                account = MCApiUtil.getAccount(accountMap);
                account.setTenantId(tenantId);
            }
        }
        return account;
    }

    @Override
    public List<TripInfo> getTripInfo(String outsystemflag) {
        PermissionManager.check();
        ArrayList<TripInfo> list = new ArrayList<TripInfo>(2);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String clusterName = ClusterUtil.getClusterNameForUsingDataCenter();
        map.put("clusterName", clusterName);
        map.put("outSystemFlag", outsystemflag);
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_GET_TRIP_INFO, true, null, map);
        List lstTenant = (List)obj;
        for (Map t : lstTenant) {
            TripInfo info = new TripInfo();
            info.setAccountId(String.valueOf(t.get("accountid")));
            info.setTenantId(String.valueOf(t.get("tenantid")));
            info.setUser(String.valueOf(t.get("user")));
            list.add(info);
        }
        return list;
    }

    @Override
    public WebClientFiles getWebClientFiles(String tenantId, String keys) throws Exception {
        PermissionManager.check();
        if (StringUtils.isEmpty((String)tenantId)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230tenantId\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_0", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)keys)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230keys\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_1", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("tenantid", tenantId);
        map.put("keys", keys);
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_GETWEBCLIENTFILESSERVICE, true, null, map);
        if (obj instanceof String) {
            return null;
        }
        Map centerMap = (Map)obj;
        return MCApiUtil.getWebClientFiles(centerMap);
    }

    @Override
    public void setWebClientFiles(WebClientFiles webClientFiles) throws Exception {
        PermissionManager.check();
        if (StringUtils.isEmpty((String)webClientFiles.getIsv())) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230isv\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_2", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)webClientFiles.getTenantId())) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230tenantid\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_3", (String)"bos-dbengine", (Object[])new Object[0]), null);
        }
        if (StringUtils.isEmpty((String)webClientFiles.getDcid())) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230dcid\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_4", (String)"bos-dbengine", (Object[])new Object[0]), null);
        }
        if (webClientFiles.getFiles() == null) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230files\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_5", (String)"bos-dbengine", (Object[])new Object[0]), null);
        }
        for (File file : webClientFiles.getFiles()) {
            if (StringUtils.isEmpty((String)file.getName())) {
                throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230files \u4e2d  name\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_6", (String)"bos-dbengine", (Object[])new Object[0]), null);
            }
            if (StringUtils.isEmpty((String)file.getFileServerPath())) {
                throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230files \u4e2d  serverpath\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_7", (String)"bos-dbengine", (Object[])new Object[0]), null);
            }
            if (StringUtils.isEmpty((String)file.getServerType())) {
                throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230files \u4e2d  serverType\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_8", (String)"bos-dbengine", (Object[])new Object[0]), null);
            }
            if (!"FS".equals(file.getServerType()) || !StringUtils.isEmpty((String)file.getDestPath())) continue;
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230files \u4e2d  destpath\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_9", (String)"bos-dbengine", (Object[])new Object[0]), null);
        }
        if (webClientFiles != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantid", webClientFiles.getTenantId());
            map.put("keys", webClientFiles.getKeys());
            map.put("isv", webClientFiles.getIsv());
            map.put("dcid", webClientFiles.getDcid());
            map.put("accountId", webClientFiles.getAccountId());
            map.put("files", this.getFilesMap(webClientFiles.getFiles()));
            map.put("relativePath", webClientFiles.getIsRelativePath());
            Object object = MCApiUtil.getMCAPIInfo(MC_API_WEBCLIENTFILESSAVESERVICE, true, null, map, MCApiUtil.getCustTimeout());
        }
    }

    private Object getFilesMap(List<File> files) {
        ArrayList List2 = new ArrayList();
        if (files != null) {
            for (File file : files) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("destpath", file.getDestPath());
                map.put("fileserverpath", file.getFileServerPath());
                map.put("name", file.getName());
                map.put("servertype", file.getServerType());
                map.put("needupdate", file.isNeedUpdate());
                List2.add(map);
            }
        }
        return List2;
    }

    @Override
    public void setMCData(String DCID, String key, String value) throws Exception {
        PermissionManager.check();
        if (StringUtils.isEmpty((String)DCID)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230DCID\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_10", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230key\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_11", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)value)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230value\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_12", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("DCID", DCID);
        map.put("key", key);
        map.put("value", value);
        map.put("accountId", "1534940270167623836");
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_SET_MC_DATA, true, null, map);
    }

    @Override
    public String getMCData(String DCID, String key) throws Exception {
        String returnValue;
        block5: {
            PermissionManager.check();
            returnValue = null;
            if (StringUtils.isEmpty((String)DCID)) {
                throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230DCID\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_10", (String)"bos-dbengine", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)key)) {
                throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230key\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_11", (String)"bos-dbengine", (Object[])new Object[0]));
            }
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("DCID", DCID);
            map.put("key", key);
            try {
                Object obj = MCApiUtil.getMCAPIInfo(MC_API_GET_MC_DATA, true, null, map);
                if (obj != null) {
                    returnValue = obj.toString();
                }
            }
            catch (KDException e) {
                if ("626".equals(e.getErrorCode().getCode())) break block5;
                throw e;
            }
        }
        return returnValue;
    }

    @Override
    public List<DBObject> getDbInstanceList(String dataCenterId) throws Exception {
        PermissionManager.check();
        ArrayList<DBObject> returnList = new ArrayList<DBObject>();
        if (StringUtils.isEmpty((String)dataCenterId)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230dataCenterId\u4e3a\u7a7a", (String)"LoginMCServiceApiImpl_13", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("dataCenterId", dataCenterId);
        try {
            Object obj = MCApiUtil.getMCAPIInfo("/kapi/app/mc/GetDbInstanceListService", true, null, map);
            if (obj != null) {
                List dbMapList = (List)obj;
                for (Map dbMap : dbMapList) {
                    DBObject dbObject = new DBObject();
                    dbObject.setName(MCApiUtil.getString(dbMap.get("name")));
                    dbObject.setNumber(MCApiUtil.getString(dbMap.get("number")));
                    returnList.add(dbObject);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw e;
        }
        return returnList;
    }

    @Override
    public Boolean getGrayEnvironmentInfo() throws Exception {
        PermissionManager.check();
        try {
            String clusterName = Instance.getClusterName();
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("clusterNumber", clusterName);
            Object obj = MCApiUtil.getMCAPIInfo(MC_API_GETGRAYENVIRONMENTINFO, true, null, map);
            if (obj != null) {
                Map objectMap = (Map)obj;
                String isBGDeploy = MCApiUtil.getString(objectMap.get("isBGDeploy"));
                if (StringUtils.isNotEmpty((String)isBGDeploy) && Boolean.parseBoolean(isBGDeploy)) {
                    return true;
                }
                String isCurrentGreen = MCApiUtil.getString(objectMap.get("isCurrentGreen"));
                if (StringUtils.isNotEmpty((String)isCurrentGreen) && Boolean.parseBoolean(isCurrentGreen)) {
                    return true;
                }
                return false;
            }
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
        }
        return false;
    }

    @Override
    public void updateGrayUserInfo(Map<String, Object> map) throws Exception {
        PermissionManager.check();
        try {
            MCApiUtil.getMCAPIInfo(MC_API_UPDATEGRAYUSERINFO, true, null, map);
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
    }

    @Override
    public Map<String, Object> getGrayAppGroup() throws Exception {
        PermissionManager.check();
        try {
            String clusterName = Instance.getClusterName();
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("clusterNumber", clusterName);
            Object obj = MCApiUtil.getMCAPIInfo(MC_API_GETGRAYAPPGROUP, true, null, map);
            if (obj != null) {
                Map objectMap = (Map)obj;
                return objectMap;
            }
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
        return null;
    }

    @Override
    public void upgradeGrayStrategy(Map<String, Object> userMap) throws Exception {
        PermissionManager.check();
        try {
            MCApiUtil.getMCAPIInfo(MC_API_UPGRADEGRAYSTRATEGY, true, null, userMap);
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
    }

    @Override
    public String callMcApiService(String url, String contentType, Map<String, String> header, Map<String, Object> params, int timeOut) throws Exception {
        PermissionManager.check();
        try {
            return MCApiUtil.callMcApiService(url, contentType, header, params);
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
    }
}

