/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.bundle.Resources;
import kd.bos.db.DBType;
import kd.bos.db.datasource.ConfiguredDataSource;
import kd.bos.db.datasource.ConfiguredDataSources;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.url.DcUrlServiceManager;
import kd.bos.dc.url.UrlServiceInterface;
import kd.bos.dc.utils.ClusterUtil;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.instance.Instance;
import kd.bos.ksql.CONSTANT;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.security.PermissionManager;
import kd.bos.tenant.TenantInfo;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.util.StringUtils;

public class AccountUtils {
    private static Log logger = LogFactory.getLog(AccountUtils.class);
    private static Map<String, List<Account>> datacenerMap = new ConcurrentHashMap<String, List<Account>>();
    private static List<TenantInfo> allTenantList = new ArrayList<TenantInfo>();
    private static UrlServiceInterface urlService = DcUrlServiceManager.getDefaultService();

    private static List<Account> getAllAccountListInner(String tenantId) {
        List<Account> accountList = LoginMCService.create().getAllAccounts(tenantId);
        ConfiguredDataSource configuredDataSource = ConfiguredDataSources.createConfiguredDataSource();
        if (configuredDataSource.hasConfiguredDataSource()) {
            for (Account account : accountList) {
                Account configuredAccount = configuredDataSource.getExtendAccount(tenantId, account.getAccountId());
                if (configuredAccount == null) continue;
                AccountUtils.mergeConfiguredAccount(account, configuredAccount);
            }
        }
        return accountList;
    }

    private static void mergeConfiguredAccount(Account account, Account configuredAccount) {
        if (configuredAccount.getDBInstanceList() == null || configuredAccount.getDBInstanceList().isEmpty()) {
            return;
        }
        Map<String, List<DBInstance>> instanceMap = AccountUtils.expandDBInstance(account);
        Map<String, List<DBInstance>> configuredInstanceMap = AccountUtils.expandDBInstance(configuredAccount);
        for (Map.Entry<String, List<DBInstance>> entry : instanceMap.entrySet()) {
            List removeList;
            List<DBInstance> configuredDBInstanceList = configuredInstanceMap.get(entry.getKey());
            if (configuredDBInstanceList == null || configuredDBInstanceList.isEmpty()) continue;
            List readwriteList = configuredDBInstanceList.stream().filter(i -> !i.isReadOnly()).collect(Collectors.toList());
            List readonlyList = configuredDBInstanceList.stream().filter(DBInstance::isReadOnly).collect(Collectors.toList());
            List<DBInstance> source = entry.getValue();
            if (!readwriteList.isEmpty()) {
                removeList = source.stream().filter(i -> !i.isReadOnly()).collect(Collectors.toList());
                source.removeAll(removeList);
            }
            if (!readonlyList.isEmpty()) {
                removeList = source.stream().filter(DBInstance::isReadOnly).collect(Collectors.toList());
                source.removeAll(removeList);
            }
            if (!readwriteList.isEmpty()) {
                source.add((DBInstance)readwriteList.get(0));
            }
            if (readonlyList.isEmpty()) continue;
            source.addAll(readonlyList);
        }
        for (Map.Entry<String, List<DBInstance>> entry : configuredInstanceMap.entrySet()) {
            if (instanceMap.containsKey(entry.getKey())) continue;
            instanceMap.put(entry.getKey(), entry.getValue());
        }
        ArrayList<DBInstance> instanceList = new ArrayList<DBInstance>(128);
        for (List<DBInstance> value : instanceMap.values()) {
            instanceList.addAll(value);
        }
        account.setDBInstanceList(instanceList);
    }

    private static Map<String, List<DBInstance>> expandDBInstance(Account account) {
        HashMap<String, List<DBInstance>> instanceMap = new HashMap<String, List<DBInstance>>(account.getDBInstanceList().size());
        for (DBInstance dbInstance : account.getDBInstanceList()) {
            List list = instanceMap.computeIfAbsent(dbInstance.getRouteKey(), k -> new ArrayList());
            list.add(dbInstance);
        }
        return instanceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAccounts(TenantListenerInfo tenantListenerInfo) {
        Class<Account> clazz = Account.class;
        synchronized (Account.class) {
            List<Account> oldList = datacenerMap.get(tenantListenerInfo.getTenantnumber());
            if (oldList != null) {
                for (Account account : oldList) {
                    MCDBUtil.removeDataSouce(account.getAccountId());
                }
                oldList.removeAll(tenantListenerInfo.getAccountList());
                if (oldList.size() == 0 && allTenantList != null) {
                    for (TenantInfo tenantInfo : allTenantList) {
                        if (!tenantListenerInfo.getTenantnumber().equals(tenantInfo.getId())) continue;
                        allTenantList.remove(tenantInfo);
                        break;
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTenant(TenantListenerInfo tenantListenerInfo) {
        Class<Account> clazz = Account.class;
        synchronized (Account.class) {
            allTenantList = LoginMCService.create().getWholeTenantsByCurrentEnv();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAccountList(String tenantId) {
        Class<Account> clazz = Account.class;
        synchronized (Account.class) {
            datacenerMap.put(tenantId, AccountUtils.getAllAccountListInner(tenantId));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static List<Account> getAllAccounts(String tenantId) {
        PermissionManager.check();
        if (tenantId == null || tenantId.trim().length() == 0) {
            throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"AccountUtils_0", (String)"\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a: ", (Object[])new Object[0]) + tenantId);
        }
        return datacenerMap.computeIfAbsent(tenantId, AccountUtils::getAllAccountListInner);
    }

    public static Account getSingleAccount(List<Account> accountList, String accountId) {
        Account returnCenter = null;
        if (accountList != null && StringUtils.isNotEmpty((String)accountId)) {
            for (Account center : accountList) {
                if (!accountId.equals(center.getAccountId())) continue;
                returnCenter = center;
                if (!logger.isDebugEnabled()) break;
                logger.debug(String.format("getSingleAccount\u5f97\u5230\u7684\u6570\u636e\u4e2d\u5fc3\u4e3a:%S", center.toString()));
                break;
            }
        }
        return returnCenter;
    }

    public static Properties getTenantDBInfo(Account currentAccount) {
        PermissionManager.check();
        if (currentAccount == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_1", (String)"\u6570\u636e\u4e2d\u5fc3\u6570\u636e\u5e93\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e \u3002\u3002", (Object[])new Object[0])});
        }
        Properties dbProperties = null;
        try {
            DBInstance instance = currentAccount.getDefaultDBInstance();
            dbProperties = AccountUtils.getPropertiesByDBInstance(instance);
            if (dbProperties == null) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_2", (String)"\u6570\u636e\u4e2d\u5fc3\u6570\u636e\u5e93\u4fe1\u606f\u83b7\u53d6\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e \u3002", (Object[])new Object[0])});
            }
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_3", (String)"\u6570\u636e\u4e2d\u5fc3\u6570\u636e\u5e93\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e \u3002", (Object[])new Object[0]) + e.getMessage()});
        }
        return dbProperties;
    }

    public static Properties getTenantDBInfoByRoutekey(Account currentAccount, String routeKey) {
        PermissionManager.check();
        if (currentAccount == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_1", (String)"\u6570\u636e\u4e2d\u5fc3\u6570\u636e\u5e93\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e \u3002\u3002", (Object[])new Object[0])});
        }
        Properties dbProperties = null;
        try {
            DBInstance instance = currentAccount.getDBInstanceByRouteKey(routeKey);
            dbProperties = AccountUtils.getPropertiesByDBInstance(instance);
            if (dbProperties == null) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_2", (String)"\u6570\u636e\u4e2d\u5fc3\u6570\u636e\u5e93\u4fe1\u606f\u83b7\u53d6\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e \u3002", (Object[])new Object[0])});
            }
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.getString((String)"bos-dbengine", (String)"AccountUtils_3", (Object[])new Object[]{"\u6570\u636e\u4e2d\u5fc3\u6570\u636e\u5e93\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e \u3002"})});
        }
        return dbProperties;
    }

    public static Properties getPropertiesByDBInstance(DBInstance instance) {
        DBType dbTypeEnum;
        Properties dbProperties = new Properties();
        if (instance == null || StringUtils.isEmpty((String)instance.getDbip())) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.getString((String)"bos-dbengine", (String)"AccountUtils_1", (Object[])new Object[]{"\u6570\u636e\u4e2d\u5fc3\u6570\u636e\u5e93\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e \u3002\u3002"})});
        }
        int dbType = Integer.parseInt(instance.getDbtype());
        String user = instance.getDbuser();
        String ip = instance.getDbip();
        String password = instance.getDbpassword();
        String port = instance.getDbport();
        String dbInstance = instance.getDBInsatnce();
        boolean cluster = instance.isCluster();
        String clusterDbUrl = instance.getClusterDbUrl();
        String driver = "";
        String url = "";
        if (dbType == 0) {
            dbTypeEnum = DBType.Oracle;
            driver = "oracle.jdbc.driver.OracleDriver";
            if (cluster) {
                String[] allIpPort;
                StringBuilder sb = new StringBuilder();
                sb.append("jdbc:oracle:thin:@(DESCRIPTION=(ENABLE=BROKEN)(LOAD_BALANCE=on)(FAILOVER=on)(ADDRESS_LIST=");
                for (String singleIpPort : allIpPort = clusterDbUrl.split(",")) {
                    String[] ipPort = singleIpPort.split(":");
                    sb.append("(ADDRESS=(PROTOCOL=tcp)(HOST=");
                    sb.append(ipPort[0]);
                    sb.append(")(PORT=");
                    sb.append(ipPort[1]);
                    sb.append("))");
                }
                sb.append(")(CONNECT_DATA=(SERVICE_NAME=");
                sb.append(instance.getDbSchema());
                sb.append(")))");
                url = sb.toString();
            } else {
                url = "jdbc:oracle:thin:@" + ip + ":" + port + "/" + dbInstance;
            }
        } else if (dbType == 1) {
            if (Boolean.getBoolean("pg_as_gs")) {
                dbTypeEnum = DBType.GS;
                driver = "org.postgresql.Driver";
                url = "jdbc:postgresql://" + ip + ":" + port + "/" + dbInstance;
            } else if (Boolean.getBoolean("pg_as_gs100")) {
                dbTypeEnum = DBType.GS100;
                driver = "com.huawei.gauss.jdbc.ZenithDriver";
                url = "jdbc:zenith:@" + ip + ":" + port;
            } else {
                dbTypeEnum = DBType.PostgreSQL;
                driver = "org.postgresql.Driver";
                url = cluster ? "jdbc:postgresql://" + clusterDbUrl + "/" + dbInstance : "jdbc:postgresql://" + ip + ":" + port + "/" + dbInstance;
                if (CONSTANT.CONNECTION_SHARD) {
                    dbProperties.put("currentSchema", instance.getDbSchema());
                }
            }
        } else if (dbType == 2) {
            dbTypeEnum = DBType.MySQL;
            if (DataSourceURLs.isUseMariaDbDriver()) {
                driver = "org.mariadb.jdbc.Driver";
                url = "jdbc:mariadb://" + ip + ":" + port + "/" + dbInstance;
            } else {
                driver = "com.mysql.cj.jdbc.Driver";
                url = cluster ? "jdbc:mysql://" + clusterDbUrl + "/" + dbInstance : "jdbc:mysql://" + ip + ":" + port + "/" + dbInstance;
            }
        } else if (dbType == 3) {
            dbTypeEnum = DBType.DM;
            driver = "dm.jdbc.driver.DmDriver";
            if (cluster) {
                url = "jdbc:dm://" + DataSourceURLs.dmClusterServerName + "?" + DataSourceURLs.dmClusterServerName + "=(" + clusterDbUrl + ")";
            } else {
                url = "jdbc:dm://" + ip + ":" + port + "/" + dbInstance;
                url = url + "?schema=" + dbInstance + "&compatibleMode=oracle&user=" + user + "&password=" + password;
            }
        } else if (dbType == 4) {
            if (Boolean.getBoolean("pg_as_gs100")) {
                dbTypeEnum = DBType.GS100;
                driver = "com.huawei.gauss.jdbc.ZenithDriver";
                url = "jdbc:zenith:@" + ip + ":" + port;
            } else {
                dbTypeEnum = DBType.GS;
                driver = "org.postgresql.Driver";
                url = "jdbc:postgresql://" + ip + ":" + port + "/" + dbInstance;
            }
        } else if (dbType == 5) {
            dbTypeEnum = DBType.GS100;
            driver = "com.huawei.gauss.jdbc.ZenithDriver";
            url = "jdbc:zenith:@" + ip + ":" + port;
        } else if (dbType == 6) {
            dbTypeEnum = DBType.SQLServer;
            driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            url = "jdbc:sqlserver://" + ip + ":" + port + ";DatabaseName=" + dbInstance + (DataSourceURLs.sqlServerUnusedTLS ? ";encrypt=false;trustServerCertificate=true" : "");
        } else if (dbType == 14) {
            dbTypeEnum = DBType.GaussDB;
            driver = "com.huawei.opengauss.jdbc.Driver";
            url = cluster ? "jdbc:opengauss://" + clusterDbUrl + "/" + dbInstance : "jdbc:opengauss://" + ip + ":" + port + "/" + dbInstance;
            if (CONSTANT.CONNECTION_SHARD) {
                dbProperties.put("currentSchema", instance.getDbSchema());
            }
        } else if (dbType == 15) {
            dbTypeEnum = DBType.KingBase;
            driver = "com.kingbase8.Driver";
            url = "jdbc:kingbase8://" + ip + ":" + port + "/" + dbInstance;
        } else if (dbType == 16) {
            dbTypeEnum = DBType.Vastbase;
            driver = "cn.com.vastbase.Driver";
            url = "jdbc:vastbase://" + ip + ":" + port + "/" + dbInstance;
        } else if (dbType == 17) {
            dbTypeEnum = DBType.TDSQL;
            driver = "com.tencentcloud.tdsql.mysql.cj.jdbc.Driver";
            url = cluster ? "jdbc:tdsql-mysql:loadbalance://" + clusterDbUrl + "/" + dbInstance : "jdbc:tdsql-mysql://" + ip + ":" + port + "/" + dbInstance;
        } else if (dbType == 18) {
            dbTypeEnum = DBType.Gbase;
            driver = "org.gbase.Driver";
            url = cluster ? "jdbc:gbase://" + clusterDbUrl + "/" + dbInstance : "jdbc:gbase://" + ip + ":" + port + "/" + dbInstance;
            if (CONSTANT.CONNECTION_SHARD) {
                dbProperties.put("currentSchema", instance.getDbSchema());
            }
        } else if (dbType == 101) {
            dbTypeEnum = DBType.HANA;
            driver = "com.sap.db.jdbc.Driver";
            url = "jdbc:sap://" + ip + ":" + port + "/?databaseName=" + instance.getDbSchema();
        } else if (dbType == 103) {
            dbTypeEnum = DBType.Gauss200;
            driver = "com.huawei.gauss200.jdbc.Driver";
            url = cluster ? "jdbc:gaussdb://" + clusterDbUrl + "/" + dbInstance : "jdbc:gaussdb://" + ip + ":" + port + "/" + dbInstance;
            if (CONSTANT.CONNECTION_SHARD) {
                dbProperties.put("currentSchema", instance.getDbSchema());
            }
        } else if (dbType == 19) {
            dbTypeEnum = DBType.TiDB;
            if (DataSourceURLs.isTiDBUseDriver5()) {
                driver = "com.kingdee.tidb.mysql.jdbc.Driver";
                url = "jdbc:tidb-mysql://" + ip + ":" + port + "/" + dbInstance;
            } else {
                driver = "com.mysql.cj.jdbc.Driver";
                url = "jdbc:mysql://" + ip + ":" + port + "/" + dbInstance;
            }
        } else if (dbType == 20) {
            dbTypeEnum = DBType.YasDB;
            driver = "com.yashandb.jdbc.Driver";
            url = cluster ? "jdbc:yasdb://" + clusterDbUrl + "/" + dbInstance : "jdbc:yasdb://" + ip + ":" + port + "/" + dbInstance;
        } else if (dbType == 21) {
            dbTypeEnum = DBType.OceanBase_Oracle;
            driver = "com.oceanbase.jdbc.Driver";
            url = "jdbc:oceanbase://" + ip + ":" + port + "/" + dbInstance;
        } else if (dbType == 104) {
            dbTypeEnum = DBType.Greenplum;
            driver = "com.pivotal.jdbc.GreenplumDriver";
            url = cluster ? "jdbc:pivotal:greenplum://" + clusterDbUrl + ";;DatabaseName=" + dbInstance : "jdbc:pivotal:greenplum://" + ip + ":" + port + ";;DatabaseName=" + dbInstance;
            url = url + ";initializationString=set search_path to " + instance.getDbSchema();
        } else {
            throw new IllegalArgumentException("Unsupported db instance type: " + dbType);
        }
        String appendURL = System.getProperty("db.url.append", "");
        url = DataSourceURLs.appendURL(url, appendURL);
        url = cluster ? DataSourceURLs.appendURL(url, DataSourceURLs.getClusterAppendURL(dbTypeEnum)) : DataSourceURLs.appendURL(url, DataSourceURLs.getAppendURL(dbTypeEnum));
        if (dbType == 2) {
            url = DataSourceURLs.appendURL(url, DataSourceURLs.getDefaultMySqlAppendURL());
        }
        AccountUtils.putDBInfo(driver, url, user, password, dbProperties);
        return dbProperties;
    }

    private static Properties putDBInfo(String driver, String url, String user, String password, Properties props) {
        props.setProperty("driverClassName", driver);
        props.setProperty("url", url);
        props.setProperty("username", user);
        props.setProperty("password", password);
        props.setProperty("user", user);
        props.setProperty("password", password);
        return props;
    }

    public static Account getCorrectAccount(String accountId, String tenantId) throws KDException {
        List<Account> accountList = AccountUtils.getAllAccounts(tenantId);
        Account currentAccount = AccountUtils.getCorrectAccount(accountId, tenantId, accountList);
        if (currentAccount == null) {
            accountList = AccountUtils.getForceReloadAllAccounts(tenantId);
            currentAccount = AccountUtils.getCorrectAccount(accountId, tenantId, accountList);
        }
        if (currentAccount == null) {
            if (StringUtils.isNotEmpty((String)accountId) && !StringUtils.isNumeric((String)accountId.trim())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"AccountId format error."});
            }
            throw new KDException(LoginErrorCode.loginWrongAccountException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_4", (String)"%1$s,%2$s\u6ca1\u6709\u5f97\u5230\u6570\u636e\u4e2d\u5fc3\u6570\u636e!@%3$s:%4$s:%5$s", (Object[])new Object[]{accountId, tenantId, ClusterUtil.getClusterNameForUsingDataCenter(), Instance.getAppName(), Instance.getInstanceId()})});
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u5f97\u5230\u7684\u6570\u636e\u4e2d\u5fc3\u4e3a:%s", currentAccount.toString()));
        }
        return currentAccount;
    }

    private static Account getCorrectAccount(String accountId, String tenantId, List<Account> accountList) throws KDException {
        Account currentAccount;
        if (StringUtils.isNotEmpty((String)accountId)) {
            currentAccount = AccountUtils.getSingleAccount(accountList, accountId);
        } else {
            String url = AccountUtils.removeHttpFromURL(AccountUtils.getDomainUrl(tenantId));
            if (accountList != null && StringUtils.isNotEmpty((String)url)) {
                for (Account account : accountList) {
                    if (!StringUtils.isNotEmpty((String)account.getDocDomain()) || !url.startsWith(account.getDocDomain())) continue;
                    Account currentAccount2 = account;
                    return currentAccount2;
                }
            }
            if ((currentAccount = AccountUtils.getDefaultAccount(accountList)) == null) {
                currentAccount = AccountUtils.getFirstAccount(accountList);
            }
        }
        return currentAccount;
    }

    private static List<Account> getForceReloadAllAccounts(String tenantId) {
        if (tenantId == null || tenantId.trim().length() == 0) {
            throw new IllegalArgumentException("TenantId can not be null or empty.");
        }
        AccountUtils.updateAccountList(tenantId);
        return AccountUtils.getAllAccounts(tenantId);
    }

    private static String removeHttpFromURL(String url) {
        String returnValue = url;
        if (StringUtils.isNotEmpty((String)url)) {
            if (url.trim().toLowerCase().startsWith("http://")) {
                returnValue = url.substring(7, url.trim().length());
            } else if (url.trim().toLowerCase().startsWith("https://")) {
                returnValue = url.substring(8, url.trim().length());
            }
        }
        return returnValue;
    }

    private static String getDomainUrl(String tenantId) {
        String url = "";
        if (urlService == null) {
            urlService = DcUrlServiceManager.getDefaultService();
            url = urlService.getDomainContexUrl(tenantId);
        } else {
            url = urlService.getDomainContexUrl(tenantId);
        }
        return url;
    }

    public static Account getAccountById(String accountId) {
        PermissionManager.check();
        List<Account> tList = AccountUtils.getAllAccountsOfCurrentEnv();
        Account currentAccount = null;
        if (tList != null) {
            for (Account account : tList) {
                if (!account.getAccountId().equals(accountId)) continue;
                currentAccount = account;
                break;
            }
        }
        if (currentAccount == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_5", (String)"\u6570\u636e\u4e2d\u5fc3\u975e\u6cd5\u64cd\u4f5c!", (Object[])new Object[0])});
        }
        return currentAccount;
    }

    public static List<Account> getAllAccountsOfCurrentEnv() {
        PermissionManager.check();
        List<TenantInfo> tenantList = AccountUtils.getAllTenantsByCurrentEnv();
        ArrayList<Account> allList = new ArrayList<Account>();
        if (tenantList != null) {
            int allSize = 0;
            for (TenantInfo tenantInfo : tenantList) {
                List<Account> accountList = AccountUtils.getAllAccounts(tenantInfo.getId());
                if (accountList == null) continue;
                allSize += accountList.size();
                allList.addAll(accountList);
            }
        }
        return allList;
    }

    public static synchronized List<TenantInfo> getAllTenantsByCurrentEnv() {
        PermissionManager.check();
        if ((allTenantList == null || allTenantList.isEmpty()) && ((allTenantList = LoginMCService.create().getWholeTenantsByCurrentEnv()) == null || allTenantList.isEmpty())) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.getString((String)"bos-dbengine", (String)"AccountUtils_6", (Object[])new Object[]{"\u5f53\u524d\u73af\u5883\u6ca1\u6709\u53ef\u7528\u7684\u79df\u6237!"})});
        }
        return allTenantList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TenantInfo getTenantByid(String tenantId) {
        PermissionManager.check();
        TenantInfo tenantInfo = AccountUtils.getTenantByidFromAllTenants(tenantId);
        if (tenantInfo != null) {
            return tenantInfo;
        }
        Class<AccountUtils> clazz = AccountUtils.class;
        synchronized (AccountUtils.class) {
            allTenantList = LoginMCService.create().getWholeTenantsByCurrentEnv();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            tenantInfo = AccountUtils.getTenantByidFromAllTenants(tenantId);
            if (tenantInfo != null) {
                return tenantInfo;
            }
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_7", (String)"tenantId\u975e\u6cd5\u64cd\u4f5c!", (Object[])new Object[0])});
        }
    }

    private static TenantInfo getTenantByidFromAllTenants(String tenantId) {
        for (TenantInfo tenantInfo : AccountUtils.getAllTenantsByCurrentEnv()) {
            if (!tenantInfo.getId().equals(tenantId)) continue;
            return tenantInfo;
        }
        return null;
    }

    public static List<TenantInfo> getTenantInfoByEid(String eid) {
        PermissionManager.check();
        ArrayList<TenantInfo> returnList = new ArrayList<TenantInfo>();
        if (StringUtils.isEmpty((String)eid)) {
            return null;
        }
        block0: for (TenantInfo tenantInfo : AccountUtils.getAllTenantsByCurrentEnv()) {
            List<Account> list = AccountUtils.getAllAccounts(tenantInfo.getId());
            if (list == null) continue;
            for (Account account : list) {
                if (!eid.equals(account.getEid())) continue;
                if (returnList.contains(tenantInfo)) continue block0;
                returnList.add(tenantInfo);
                continue block0;
            }
        }
        return returnList;
    }

    public static List<TenantInfo> getTenantInfoByEids(List<Long> eids) {
        PermissionManager.check();
        ArrayList<TenantInfo> returnList = new ArrayList<TenantInfo>();
        for (TenantInfo tenantInfo : AccountUtils.getAllTenantsByCurrentEnv()) {
            List<Account> list = AccountUtils.getAllAccounts(tenantInfo.getId());
            if (list == null) continue;
            block1: for (Account account : list) {
                for (long eid : eids) {
                    if (!String.valueOf(eid).equals(account.getEid())) continue;
                    returnList.add(tenantInfo);
                    continue block1;
                }
            }
        }
        return returnList;
    }

    public static Account getAccountByEid(String eid) {
        PermissionManager.check();
        if (StringUtils.isEmpty((String)eid)) {
            return null;
        }
        for (TenantInfo tenantInfo : AccountUtils.getAllTenantsByCurrentEnv()) {
            List<Account> list = AccountUtils.getAllAccounts(tenantInfo.getId());
            if (list == null) continue;
            for (Account account : list) {
                if (!eid.equals(account.getEid())) continue;
                return account;
            }
        }
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.get((String)"bos-dbengine", (String)"AccountUtils_8", (String)"%s\u975e\u6cd5\u64cd\u4f5c!", (Object[])new Object[]{eid})});
    }

    private static Account getFirstAccount(List<Account> accountList) {
        return accountList == null || accountList.isEmpty() ? null : accountList.get(0);
    }

    private static Account getDefaultAccount(List<Account> accountList) {
        if (accountList != null) {
            for (Account account : accountList) {
                if (!account.isDefault()) continue;
                return account;
            }
        }
        return null;
    }

    public static void clearAccountCache() {
        datacenerMap.clear();
        allTenantList.clear();
    }

    static {
        TenantListenerManager.addTenantListener(new TenantListener(){

            @Override
            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        AccountUtils.updateTenant(tenantListenerInfo);
                        AccountUtils.updateAccountList(tenantListenerInfo.getTenantnumber());
                        this.initialAllDatasourceOfTenant(tenantListenerInfo.getTenantnumber());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private void initialAllDatasourceOfTenant(String tenantId) {
                List<Account> accountList = AccountUtils.getAllAccounts(tenantId);
                if (accountList != null) {
                    for (Account currentAccount : accountList) {
                        MCDBUtil.initalDataSource(currentAccount, AccountUtils.getTenantDBInfo(currentAccount));
                    }
                }
            }

            @Override
            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                AccountUtils.removeAccounts(tenantListenerInfo);
            }
        });
    }
}

