/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.mc.impl.LoginMCServiceApiImpl;
import kd.bos.dc.mc.impl.LoginMCServiceDbImpl;
import kd.bos.dc.mc.impl.LoginMCServiceZKImpl;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.File;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.security.KDCallerInfo;
import kd.bos.security.KDReflection;
import kd.bos.security.PermissionManager;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.DBResources;
import org.apache.commons.lang3.ObjectUtils;

public class MCApiUtil {
    private static final String REPORT_STR = "report";
    private static Log logger = LogFactory.getLog(MCApiUtil.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("LOGIN_MC_DATA", new DistributeCacheHAPolicy(true, true));
    private static final String MC_AUTH_LOGIN_APPID = "mc_auth_login_appId";
    public static final String MC_AUTH_LOGIN_APPVAL = "mc_auth_login_appVal";

    public static Object getMCAPIInfo(String api, boolean appJson, Map<String, String> header, Map<String, Object> data) {
        PermissionManager.check();
        try {
            return MCApiUtil.getMCAPIInfo(api, appJson, header, data, 5);
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, LoginErrorCode.loginMCServerFailed, new Object[]{String.format("api=%s error=%s", api, e.getMessage())});
        }
    }

    private static void forbidCustomerCalling() {
        KDCallerInfo caller;
        if (KDReflection.isEnableSecurity() && KDReflection.isCustomerClass((Class)(caller = KDReflection.getCallerClassUntilNot((Class[])new Class[]{LoginMCServiceApiImpl.class, LoginMCServiceDbImpl.class, LoginMCServiceZKImpl.class})).getCallerClass())) {
            String msg = DBResources.getString((String)"\u7981\u6b62\u8c03\u7528MCApiUtil: ", (String)"MCApiUtil_2", (String)"bos-dbengine", (Object[])new Object[0]) + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName((int)caller.getCallStackDepth());
            throw KDReflection.securityException((String)msg);
        }
    }

    public static Object getMCAPIInfo(String api, boolean appJson, Map<String, String> header, Map<String, Object> data, int timeout) {
        PermissionManager.check();
        try {
            String resp;
            String contentType = "";
            if (appJson) {
                contentType = "application/json";
            }
            if (StringUtils.isEmpty((String)(resp = MCApiUtil.callMcApiService(api, contentType, header, data, timeout)))) {
                throw new KDException(LoginErrorCode.loginMCServerFailed, new Object[]{DBResources.getString((String)"\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25,\u65e0\u6709\u6548\u6570\u636e\u3002URL:%1$s\uff0c\u53c2\u6570:%2$s", (String)"MCApiUtil_0", (String)"bos-dbengine", (Object[])new Object[]{api, data == null ? "" : data.toString()})});
            }
            Map tenants = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true);
            if (100 != (Integer)tenants.get("errorcode")) {
                throw new KDException(new ErrorCode(String.valueOf(tenants.get("errorcode")), ""), new Object[]{String.format(DBResources.getString((String)"\u8c03\u7528\u79df\u6237\u4e2d\u5fc3\u6570\u636e\u5931\u8d25,\u539f\u56e0:%s", (String)"MCApiUtil_1", (String)"bos-dbengine", (Object[])new Object[0]), tenants.get("description"))});
            }
            return tenants.get("data");
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, LoginErrorCode.loginMCServerFailed, new Object[]{String.format("api=%s error=%s", api, e.getMessage())});
        }
    }

    public static WebClientFiles getWebClientFiles(Map<String, Object> newMap) {
        WebClientFiles webClientFiles = new WebClientFiles();
        webClientFiles.setDcid(MCApiUtil.getString(newMap.get("dcid")));
        webClientFiles.setIsv(MCApiUtil.getString(newMap.get("isv")));
        webClientFiles.setKeys(MCApiUtil.getString(newMap.get("keys")));
        webClientFiles.setTenantId(MCApiUtil.getString(newMap.get("tenantId")));
        List fileList = null;
        try {
            fileList = (List)newMap.get("files");
            ArrayList<File> lastFileList = new ArrayList<File>(fileList.size());
            for (Map fileMap : fileList) {
                File file = new File();
                file.setDestPath(MCApiUtil.getString(fileMap.get("destPath")));
                file.setFileServerPath(MCApiUtil.getString(fileMap.get("fileServerPath")));
                file.setName(MCApiUtil.getString(fileMap.get("name")));
                file.setNeedUpdate(MCApiUtil.getBoolean("needUpdate"));
                file.setServerType(MCApiUtil.getString(fileMap.get("serverType")));
                lastFileList.add(file);
            }
            webClientFiles.setFiles(lastFileList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("1", DBResources.getString((String)"\u91d1\u8776\u4e91\u7ba1\u7406\u4e2d\u5fc3\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e:", (String)"MCApiUtil_3", (String)"bos-dbengine", (Object[])new Object[0]) + e.getMessage()), new Object[0]);
        }
        return webClientFiles;
    }

    public static Account getAccount(Map<String, Object> accountMap) {
        DBInstance reportDBInstance;
        PermissionManager.check();
        Account account = new Account();
        account.setAccountId(MCApiUtil.getString(accountMap.get("datacenterid")));
        account.setAccountName(MCApiUtil.getString(accountMap.get("datacentername")));
        account.setAccountNumber(MCApiUtil.getString(accountMap.get("datacenternumber")));
        account.setDefault(MCApiUtil.getBoolean(accountMap.get("isdefault")));
        account.setEid(String.valueOf(accountMap.get("eid")));
        account.setKeyFile(MCApiUtil.getString(accountMap.get("keyfile")));
        account.setSsoPlugin(MCApiUtil.getString(accountMap.get("ssoplugin")));
        account.setUserSourceType(String.valueOf(accountMap.get("usersourcetype")));
        account.setVersion(MCApiUtil.getString(accountMap.get("version")));
        account.setYzjOrgNo(MCApiUtil.getString(accountMap.get("yzjorgno")));
        account.setYzjUrl(MCApiUtil.getString(accountMap.get("yzjurl")));
        account.setYzjWeb(MCApiUtil.getString(accountMap.get("yzjweb")));
        account.setProductVersion(MCApiUtil.getString(accountMap.get("productversion")));
        account.setSplittingRead(MCApiUtil.getBoolean(accountMap.get("dbreadonly")));
        account.setDtsEnable(MCApiUtil.getBoolean(accountMap.get("isdtsenable")));
        account.setDocDomain(MCApiUtil.getString(accountMap.get("dcDomain")));
        List instanceList = null;
        try {
            instanceList = (List)accountMap.get("instancelist");
            if (instanceList != null) {
                for (Object instanceMap : instanceList) {
                    String routeKey = MCApiUtil.getString(instanceMap.get("routekey"));
                    String readOnly = MCApiUtil.getString(instanceMap.get("readonly"));
                    String string = MCApiUtil.getString(instanceMap.get("dbinsatnce"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("1", DBResources.getString((String)"\u91d1\u8776\u4e91\u7ba1\u7406\u4e2d\u5fc3\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"MCApiUtil_4", (String)"bos-dbengine", (Object[])new Object[0])), new Object[0]);
        }
        ArrayList<DBInstance> dbList = new ArrayList<DBInstance>();
        if (instanceList != null) {
            for (Map instanceMap : instanceList) {
                String routeKey = MCApiUtil.getString(instanceMap.get("routekey"));
                String readOnly = MCApiUtil.getString(instanceMap.get("readonly"));
                String dbInsatnce = MCApiUtil.getString(instanceMap.get("dbinsatnce"));
                DBInstance instance = new DBInstance();
                instance.setRouteKey(routeKey);
                instance.setDBInsatnce(dbInsatnce);
                instance.setReadOnly(readOnly);
                String dbSchema = MCApiUtil.getString(instanceMap.get("dbschema"));
                instance.setDbSchema(dbSchema);
                instance.setDbip(MCApiUtil.getString(instanceMap.get("dbip")));
                if (instanceMap.get("dbpassword") != null) {
                    instance.setDbpassword(Encrypters.decode((String)MCApiUtil.getString(instanceMap.get("dbpassword"))));
                }
                if (instanceMap.get("dbport") instanceof String) {
                    instance.setDbport(MCApiUtil.getString(instanceMap.get("dbport")));
                } else if (instanceMap.get("dbport") instanceof Integer) {
                    instance.setDbport(String.valueOf(instanceMap.get("dbport")));
                }
                instance.setDbuser(MCApiUtil.getString(instanceMap.get("dbuser")));
                instance.setDbtype(String.valueOf(instanceMap.get("dbtype")));
                if (instanceMap.get("loadfactor") != null) {
                    try {
                        instance.setLoadFactor((Integer)instanceMap.get("loadfactor"));
                    }
                    catch (NumberFormatException e) {
                        logger.warn((Throwable)e);
                    }
                }
                instance.setClusterDbUrl(MCApiUtil.getString(instanceMap.get("dburl")));
                instance.setCluster(MCApiUtil.getBoolean(instanceMap.get("isCluster")));
                if (instanceMap.get("defaultproperties") != null) {
                    Properties defaultProperties = new Properties();
                    try {
                        defaultProperties.load(new StringReader(String.valueOf(instanceMap.get("defaultproperties"))));
                    }
                    catch (IOException e) {
                        logger.warn((Throwable)e);
                    }
                    instance.setDefaultProperties(defaultProperties);
                }
                dbList.add(instance);
            }
        }
        if ((reportDBInstance = MCApiUtil.getReportDBInstance(account.getAccountId())) != null) {
            dbList.add(reportDBInstance);
        }
        account.setDBInstanceList(dbList);
        return account;
    }

    private static DBInstance getReportDBInstance(String accountId) {
        try {
            String qingDW;
            if (StringUtils.isNotEmpty((String)accountId) && StringUtils.isNotEmpty((String)(qingDW = System.getProperty("qing_dw_" + accountId)))) {
                Map paramMap = (Map)JSONUtils.cast((String)qingDW, Map.class, (Class[])new Class[]{String.class, String.class});
                DBInstance reportDbInstance = new DBInstance();
                String type = (String)paramMap.get("type");
                String url = (String)paramMap.get("url");
                String userName = (String)paramMap.get("username");
                String passWord = (String)paramMap.get("password");
                String instance = (String)paramMap.get("instance");
                if (!"greenplum".equals(type)) {
                    throw new KDException(BosErrorCode.paramError, new Object[]{"the qing_dw type is not supported!"});
                }
                if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)passWord) || StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)instance)) {
                    throw new KDException(BosErrorCode.paramError, new Object[]{"the param of url/username/password/instance can not be empty!"});
                }
                reportDbInstance.setDbtype("104");
                reportDbInstance.setDbuser(userName);
                reportDbInstance.setDbpassword(Encrypters.decode((String)passWord));
                reportDbInstance.setDBInsatnce(instance);
                reportDbInstance.setDbSchema(REPORT_STR);
                reportDbInstance.setRouteKey("dw.report");
                reportDbInstance.setReadOnly("0");
                int urlSplitIndex = url.indexOf(":");
                if (urlSplitIndex != -1) {
                    reportDbInstance.setDbip(url.substring(0, urlSplitIndex));
                    reportDbInstance.setDbport(url.substring(urlSplitIndex + 1));
                    reportDbInstance.setCluster(false);
                } else {
                    reportDbInstance.setCluster(true);
                }
                reportDbInstance.setClusterDbUrl(url);
                return reportDbInstance;
            }
        }
        catch (Throwable t) {
            logger.error("parse qing_dw error!", t);
        }
        return null;
    }

    public static String getString(Object object) {
        return object == null ? null : String.valueOf(object);
    }

    private static boolean getBoolean(Object object) {
        boolean returnBoolan = false;
        if (object != null) {
            if (object instanceof Boolean) {
                returnBoolan = (Boolean)object;
            } else if (object instanceof String) {
                returnBoolan = Boolean.parseBoolean((String)object);
            }
        }
        return returnBoolan;
    }

    public static int getCustTimeout() {
        int timeout = 40;
        try {
            String timeOut = System.getProperty("mc.server.timeout");
            if (StringUtils.isNumeric((String)timeOut)) {
                timeout = Integer.parseInt(timeOut);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    private static String getMcAccessToken(String mcServer) throws Exception {
        String appId = System.getProperty(MC_AUTH_LOGIN_APPID);
        String token = (String)cache.get(MC_AUTH_LOGIN_APPID, appId);
        if (StringUtils.isEmpty((String)token)) {
            HashMap headerParam = new HashMap(8);
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("user", "cosmic");
            body.put("usertype", "UserName");
            body.put("appId", appId);
            String appSecuret = System.getProperty(MC_AUTH_LOGIN_APPVAL);
            if (Encrypters.isEncrypted((String)appSecuret)) {
                appSecuret = Encrypters.decode((String)appSecuret);
            }
            body.put("appSecuret", appSecuret);
            String resp = HttpClientUtils.postAppJson((String)(mcServer + "/api/login.do"), headerParam, body, (int)5000, (int)6000);
            if (StringUtils.isNotEmpty((String)resp)) {
                Map result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true);
                if (result.get("data") != null) {
                    Map tokenData = (Map)result.get("data");
                    token = tokenData.get("access_token").toString();
                    cache.put(MC_AUTH_LOGIN_APPID, appId, token, 3600);
                } else {
                    logger.info(resp);
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{resp});
                }
            }
        }
        return token;
    }

    public static boolean enableMcAuthLogin() {
        boolean flag = false;
        String appId = System.getProperty(MC_AUTH_LOGIN_APPID);
        String appSecuret = System.getProperty(MC_AUTH_LOGIN_APPVAL);
        if (StringUtils.isNotEmpty((String)appId) && StringUtils.isNotEmpty((String)appSecuret)) {
            flag = true;
        }
        return flag;
    }

    public static String callMcApiService(String api, String contentType, Map<String, String> header, Map<String, Object> params, int timeOut) {
        PermissionManager.check();
        String mcserver = System.getProperty("mc.server.url");
        if (mcserver == null) {
            throw new KDException(LoginErrorCode.loginConfigMissingKey, new Object[]{"mc.server.url"});
        }
        try {
            Map tenants;
            String acceessToken = "";
            if (MCApiUtil.enableMcAuthLogin()) {
                acceessToken = MCApiUtil.getMcAccessToken(mcserver);
            }
            if (StringUtils.isNotEmpty((String)acceessToken)) {
                if (ObjectUtils.isEmpty(header)) {
                    header = new HashMap<String, String>(8);
                }
                header.put("accessToken", acceessToken);
            }
            String url = mcserver + api;
            String resp = "";
            resp = "application/json".equalsIgnoreCase(contentType) ? HttpClientUtils.postAppJson((String)url, header, params, (int)(timeOut * 1000), (int)((timeOut + 1) * 1000)) : ("text/json".equalsIgnoreCase(contentType) ? HttpClientUtils.postjson((String)url, header, (String)JSONUtils.toString(params), (int)(timeOut * 1000), (int)((timeOut + 1) * 1000)) : HttpClientUtils.post((String)url, header, params));
            if (StringUtils.isNotEmpty((String)resp) && "401".equals((tenants = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true)).get("errorCode"))) {
                String appId = System.getProperty(MC_AUTH_LOGIN_APPID);
                cache.remove(MC_AUTH_LOGIN_APPID, appId);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{resp});
            }
            return resp;
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, LoginErrorCode.loginMCServerFailed, new Object[]{String.format("api=%s error=%s", api, e.getMessage())});
        }
    }

    public static String callMcApiService(String api, String contentType, Map<String, String> header, Map<String, Object> params) {
        PermissionManager.check();
        return MCApiUtil.callMcApiService(api, contentType, header, params, 5);
    }
}

