/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SQLUtils {
    private static Log logger = LogFactory.getLog(SQLUtils.class);

    public static final void cleanup(Connection cn) {
        SQLUtils.cleanup(null, null, cn);
    }

    public static final void cleanup(Statement stmt) {
        SQLUtils.cleanup(null, stmt, null);
    }

    public static final void cleanup(Statement stmt, Connection cn) {
        SQLUtils.cleanup(null, stmt, cn);
    }

    public static final void cleanup(ResultSet rs) {
        SQLUtils.cleanup(rs, null, null);
    }

    public static final void cleanup(ResultSet rs, Statement stmt) {
        SQLUtils.cleanup(rs, stmt, null);
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                logger.error("cleanup error", (Throwable)e);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                logger.error("cleanup error", (Throwable)e);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception e) {
                logger.error("cleanup error", (Throwable)e);
            }
            cn = null;
        }
    }

    public static void execute(Connection conn, String sql) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException sqle) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)sqle);
        }
        finally {
            SQLUtils.cleanup(stmt);
        }
    }

    public static void main(String[] args) {
    }
}

