/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.tenant.listener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.Resources;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.ClusterUtil;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class TenantListenerManager {
    private static final String MC_ALLTENANT_KEY = "mc.tenant.ids";
    private static final String MC_TENANT_ALLDATA_KEY = "mc.tenant.%s.data";
    private static final String tenantIdsKey = "tenantIds";
    private static final String addKey = "add";
    private static final String removeKey = "remove";
    private static Map<String, String> zkDataValues = new HashMap<String, String>();
    private static List<TenantListenerWrapper> dcls = new ArrayList<TenantListenerWrapper>();
    private static Log logger = LogFactory.getLog(TenantListenerManager.class);

    public static void addTenantListener(TenantListener dcl) {
        dcls.add(new TenantListenerWrapper(dcl));
    }

    public static void addTenantListener(TenantListener dcl, int order) {
        dcls.add(new TenantListenerWrapper(dcl, order));
    }

    public static String getTenantData(String tenantNumber) {
        return zkDataValues.get(tenantNumber);
    }

    private static void zkListenerTenant(final String tenantNumber) {
        final String tenantKey = String.format(MC_TENANT_ALLDATA_KEY, tenantNumber);
        ConfigurationUtil.observeChange((String)tenantKey, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                Map result = TenantListenerManager.compareTenantDataStr(tenantNumber, (String)zkDataValues.get(tenantKey), String.valueOf(newValue));
                for (TenantListenerWrapper dclwrapper : TenantListenerManager.getDcls()) {
                    TenantListener dcl = dclwrapper.getListener();
                    for (Map.Entry entry : result.entrySet()) {
                        String tempKey = (String)entry.getKey();
                        TenantListenerInfo info = (TenantListenerInfo)entry.getValue();
                        if (TenantListenerManager.addKey.equals(tempKey)) {
                            dcl.onTenantAccountsAdded(info);
                            continue;
                        }
                        if (!TenantListenerManager.removeKey.equals(tempKey)) continue;
                        dcl.onTenantAccountsRemoved(info);
                    }
                    TenantListenerInfo tenantListenerInfo = new TenantListenerInfo();
                    tenantListenerInfo.setTenantnumber(tenantNumber);
                    tenantListenerInfo.setTenantData(String.valueOf(newValue));
                    tenantListenerInfo.setAccountList(TenantListenerManager.getAccountList(tenantNumber, String.valueOf(newValue)));
                    dcl.onTenantChanged(tenantListenerInfo);
                }
                zkDataValues.put(tenantKey, String.valueOf(newValue));
            }
        });
    }

    private static Map<String, TenantListenerInfo> compareTenantDataStr(String tenantNumber, String oldStr, String newStr) {
        HashMap<String, TenantListenerInfo> resultMap = new HashMap<String, TenantListenerInfo>();
        HashMap<String, Map<String, Object>> oldMap = new HashMap<String, Map<String, Object>>(2);
        for (Map<String, Object> map : TenantListenerManager.jsonStrCastToMapList(oldStr)) {
            String string = String.valueOf(map.get("datacenterid"));
            oldMap.put(string, map);
        }
        HashMap<String, Map<String, Object>> newMap = new HashMap<String, Map<String, Object>>(2);
        for (Map<String, Object> map : TenantListenerManager.jsonStrCastToMapList(newStr)) {
            String string = String.valueOf(map.get("datacenterid"));
            newMap.put(string, map);
        }
        ArrayList<Account> arrayList = new ArrayList<Account>(newMap.size());
        for (Map.Entry entry : newMap.entrySet()) {
            Map map;
            String string = (String)entry.getKey();
            if (oldMap.containsKey(string) || (map = (Map)entry.getValue()).isEmpty()) continue;
            arrayList.add(MCApiUtil.getAccount(map));
        }
        if (!arrayList.isEmpty()) {
            TenantListenerInfo tenantListenerInfo = new TenantListenerInfo();
            tenantListenerInfo.setAccountList(arrayList);
            tenantListenerInfo.setTenantnumber(tenantNumber);
            tenantListenerInfo.setTenantData(newStr);
            resultMap.put(addKey, tenantListenerInfo);
        }
        ArrayList<Account> arrayList2 = new ArrayList<Account>(oldMap.size());
        for (Map.Entry entry : oldMap.entrySet()) {
            Map map;
            String key = (String)entry.getKey();
            if (newMap.containsKey(key) || (map = (Map)entry.getValue()).isEmpty()) continue;
            arrayList2.add(MCApiUtil.getAccount(map));
        }
        if (!arrayList2.isEmpty()) {
            TenantListenerInfo tenantListenerInfo = new TenantListenerInfo();
            tenantListenerInfo.setAccountList(arrayList2);
            tenantListenerInfo.setTenantnumber(tenantNumber);
            tenantListenerInfo.setTenantData(newStr);
            resultMap.put(removeKey, tenantListenerInfo);
        }
        return resultMap;
    }

    private static Map<String, List<TenantListenerInfo>> compareTenantIdListStr(String oldStr, String newStr) {
        HashMap<String, List<TenantListenerInfo>> result = new HashMap<String, List<TenantListenerInfo>>();
        List<Map<String, Object>> oldList = TenantListenerManager.jsonStrCastToMapList(oldStr);
        HashMap<String, Map<String, Object>> oldIdMap = new HashMap<String, Map<String, Object>>(oldList.size());
        for (Map<String, Object> map : oldList) {
            String tenantidStr = String.valueOf(map.get("tenantid"));
            oldIdMap.put(tenantidStr, map);
        }
        List<Map<String, Object>> newList = TenantListenerManager.jsonStrCastToMapList(newStr);
        HashMap<String, Map> newIdMap = new HashMap<String, Map>(newList.size());
        for (Map map : newList) {
            String string = String.valueOf(map.get("tenantid"));
            newIdMap.put(string, map);
        }
        ArrayList<TenantListenerInfo> addList = new ArrayList<TenantListenerInfo>(newIdMap.size());
        for (Map.Entry entry : newIdMap.entrySet()) {
            String key = (String)entry.getKey();
            if (oldIdMap.containsKey(key)) continue;
            Map map = (Map)entry.getValue();
            TenantListenerInfo tempInfo = new TenantListenerInfo();
            String tenantNumber = String.valueOf(map.get("tenantnumber"));
            tempInfo.setTenantnumber(tenantNumber);
            String tenantdata = ConfigurationUtil.getString((String)String.format(MC_TENANT_ALLDATA_KEY, tempInfo.getTenantnumber()));
            tempInfo.setTenantData(tenantdata);
            tempInfo.setAccountList(TenantListenerManager.getAccountList(tenantNumber, tenantdata));
            addList.add(tempInfo);
        }
        ArrayList<TenantListenerInfo> arrayList = new ArrayList<TenantListenerInfo>();
        for (Map.Entry entry : oldIdMap.entrySet()) {
            String key = (String)entry.getKey();
            if (newIdMap.containsKey(key)) continue;
            Map map = (Map)entry.getValue();
            TenantListenerInfo tempInfo = new TenantListenerInfo();
            String tenantNumber = String.valueOf(map.get("tenantnumber"));
            tempInfo.setTenantnumber(tenantNumber);
            String tenantdata = ConfigurationUtil.getString((String)String.format(MC_TENANT_ALLDATA_KEY, tempInfo.getTenantnumber()));
            tempInfo.setTenantData(tenantdata);
            tempInfo.setAccountList(AccountUtils.getAllAccounts(tempInfo.getTenantnumber()));
            arrayList.add(tempInfo);
        }
        result.put(addKey, addList);
        result.put(removeKey, arrayList);
        return result;
    }

    private static List<Account> getAccountList(String tenantNumber, String tenantData) {
        ArrayList<Account> resultList = new ArrayList<Account>();
        List<Map<String, Object>> list = TenantListenerManager.jsonStrCastToMapList(tenantData);
        if (!list.isEmpty()) {
            for (Map<String, Object> centerMap : list) {
                Account center = MCApiUtil.getAccount(centerMap);
                center.setTenantId(tenantNumber);
                resultList.add(center);
            }
        }
        return resultList;
    }

    private static List<Map<String, Object>> jsonStrCastToMapList(String jsonStr) {
        if (StringUtils.isEmpty((String)jsonStr) || "null".equalsIgnoreCase(jsonStr)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> list = new ArrayList();
        try {
            list = (List)JSONUtils.cast((String)jsonStr, ArrayList.class, (Class[])new Class[]{HashMap.class});
        }
        catch (IOException e) {
            String erroString = ClusterUtil.getClusterNameForUsingDataCenter() + String.format(Resources.get((String)"bos-dbengine", (String)"TenantListenerManager_0", (String)"json\u4e32\u89e3\u6790-->List<Map<String,Object>>\u51fa\u9519\u3002value=%s", (Object[])new Object[0]), jsonStr);
            throw new KDException(BosErrorCode.jSONParsing, new Object[]{erroString});
        }
        return list;
    }

    private static List<TenantListenerWrapper> getDcls() {
        Collections.sort(dcls, new Comparator<TenantListenerWrapper>(){

            @Override
            public int compare(TenantListenerWrapper o1, TenantListenerWrapper o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        return dcls;
    }

    static {
        String tenantIdsValue = ConfigurationUtil.getString((String)MC_ALLTENANT_KEY);
        if (StringUtils.isEmpty((String)tenantIdsValue)) {
            zkDataValues.put(tenantIdsKey, "");
        } else {
            zkDataValues.put(tenantIdsKey, tenantIdsValue);
            List<Map<String, Object>> list = TenantListenerManager.jsonStrCastToMapList(tenantIdsValue);
            for (Map<String, Object> map : list) {
                String tenantNumber = String.valueOf(map.get("tenantnumber"));
                String tenantdata = ConfigurationUtil.getString((String)String.format(MC_TENANT_ALLDATA_KEY, tenantNumber));
                if (StringUtils.isEmpty((String)tenantdata)) continue;
                zkDataValues.put(tenantNumber, tenantdata);
            }
        }
        ConfigurationUtil.observeChange((String)MC_ALLTENANT_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                Map result = TenantListenerManager.compareTenantIdListStr((String)zkDataValues.get(TenantListenerManager.tenantIdsKey), String.valueOf(newValue));
                for (Map.Entry entry : result.entrySet()) {
                    String tempKey = (String)entry.getKey();
                    for (TenantListenerInfo info : (List)entry.getValue()) {
                        for (TenantListenerWrapper dcl : TenantListenerManager.getDcls()) {
                            if (TenantListenerManager.addKey.equals(tempKey)) {
                                zkDataValues.put(info.getTenantnumber(), info.getTenantData());
                                TenantListenerManager.zkListenerTenant(info.getTenantnumber());
                                dcl.getListener().onTenantAccountsAdded(info);
                                continue;
                            }
                            if (!TenantListenerManager.removeKey.equals(tempKey)) continue;
                        }
                    }
                }
                zkDataValues.put(TenantListenerManager.tenantIdsKey, String.valueOf(newValue));
            }
        });
        for (String tenantNumber : zkDataValues.keySet()) {
            if (tenantIdsKey.equalsIgnoreCase(tenantNumber)) continue;
            TenantListenerManager.zkListenerTenant(tenantNumber);
        }
    }

    private static class TenantListenerWrapper {
        private TenantListener dcl;
        private int order = 0;

        TenantListenerWrapper(TenantListener dcl) {
            this.dcl = dcl;
        }

        TenantListenerWrapper(TenantListener dcl, int order) {
            this.dcl = dcl;
            this.order = order;
        }

        public TenantListener getListener() {
            return this.dcl;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

