/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.PooledUnsafeHeapByteBuf;
import io.netty.buffer.XCacheMemoryLimiter;
import io.netty.util.internal.PlatformDependent;

public class XCacheHeapPoolArena
extends PoolArena<byte[]> {
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    private final XCacheMemoryLimiter limiter;

    public static XCacheHeapPoolArena create(Object poolArena, XCacheMemoryLimiter limiter) {
        return new XCacheHeapPoolArena((PoolArena)poolArena, limiter);
    }

    private XCacheHeapPoolArena(PoolArena<?> poolArena, XCacheMemoryLimiter limiter) {
        super(poolArena.parent, poolArena.sizeClass);
        this.limiter = limiter;
    }

    private static byte[] newByteArray(int size) {
        return PlatformDependent.allocateUninitializedArray((int)size);
    }

    boolean isDirect() {
        return false;
    }

    protected PoolChunk<byte[]> newChunk(int pageSize, int maxPageIdx, int pageShifts, int chunkSize) {
        this.limiter.incrementMemory(chunkSize);
        return new PoolChunk((PoolArena)this, null, (Object)XCacheHeapPoolArena.newByteArray(chunkSize), pageSize, pageShifts, chunkSize, maxPageIdx);
    }

    protected PoolChunk<byte[]> newUnpooledChunk(int capacity) {
        this.limiter.incrementMemory(capacity);
        return new PoolChunk((PoolArena)this, null, (Object)XCacheHeapPoolArena.newByteArray(capacity), capacity);
    }

    protected void destroyChunk(PoolChunk<byte[]> chunk) {
        this.limiter.decrementMemory(chunk.chunkSize());
    }

    protected PooledByteBuf<byte[]> newByteBuf(int maxCapacity) {
        return HAS_UNSAFE ? PooledUnsafeHeapByteBuf.newUnsafeInstance((int)maxCapacity) : PooledHeapByteBuf.newInstance((int)maxCapacity);
    }

    protected void memoryCopy(byte[] src, int srcOffset, PooledByteBuf<byte[]> dst, int length) {
        if (length == 0) {
            return;
        }
        System.arraycopy(src, srcOffset, dst.memory, dst.offset, length);
    }
}

