/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.xcache.server.cmd.handler.CommandHandler;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.cmd.parser.CommandMetadata;
import kd.bos.xcache.server.cmd.parser.CommandParser;
import kd.bos.xcache.server.cmd.parser.MetadataBuilder;
import kd.bos.xcache.server.cmd.registry.CommandHandlerRegistry;
import kd.bos.xcache.server.cmd.registry.CommandRegistry;
import kd.bos.xcache.server.exception.CommandInvalidException;
import kd.bos.xcache.server.exception.UnsupportedCommandException;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Request;

public class CommandCenter {
    private static final CommandHandlerRegistry handlerRegistry = new CommandHandlerRegistry();
    private static final Map<CommandType, CommandMetadata> metadataMap = CommandCenter.buildMetadataMap();
    private static final CommandParser defaultParser = new CommandParser(metadataMap);

    private CommandCenter() {
    }

    private static Map<CommandType, CommandMetadata> buildMetadataMap() {
        CommandRegistry commandRegistry = new CommandRegistry();
        EnumMap<CommandType, CommandMetadata> metadataMap = new EnumMap<CommandType, CommandMetadata>(CommandType.class);
        for (CommandType each : commandRegistry.keys()) {
            CommandMetadata<Command> commandMetadata = MetadataBuilder.build((Command)commandRegistry.find(each));
            metadataMap.put(commandMetadata.getCommandType(), commandMetadata);
        }
        return metadataMap;
    }

    public static CommandMetadata metadata(CommandType commandType) {
        return commandType.isInnerCommand() ? null : metadataMap.get((Object)commandType);
    }

    public static List<CommandType> commands() {
        return metadataMap.keySet().stream().filter(type -> !type.isInnerCommand()).sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
    }

    public static Command parse(Request request) throws CommandInvalidException {
        return defaultParser.parse(request);
    }

    public static CommandHandler getHandler(CommandType command) throws UnsupportedCommandException {
        CommandHandler handler = (CommandHandler)handlerRegistry.find(command);
        if (null == handler) {
            throw new UnsupportedCommandException(command.name());
        }
        return handler;
    }
}

