/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.ExpireAtCommand;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;

public class ExpireAtCommandHandler
extends AbstractCommandHandler<ExpireAtCommand> {
    @Override
    public CommandType type() {
        return CommandType.EXPIREAT;
    }

    @Override
    public Result doHandle(CommandContext context, ExpireAtCommand command) {
        long timestampInMiss = Math.min(command.getTimestamp() * 1000L, System.currentTimeMillis() + ServerPlatform.maxExpireTime() * 1000L);
        long result = context.globalIndex().expireAt(command.getKey(), timestampInMiss);
        return Results.success().andReturn(Value.newLong(result));
    }
}

