/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.ExpireCommand;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;

public class ExpireCommandHandler
extends AbstractCommandHandler<ExpireCommand> {
    @Override
    public CommandType type() {
        return CommandType.EXPIRE;
    }

    @Override
    public Result doHandle(CommandContext context, ExpireCommand command) {
        long currentTime = System.currentTimeMillis();
        long expireSeconds = Math.min(command.getSeconds(), ServerPlatform.maxExpireTime());
        long addTimeMillis = expireSeconds * 1000L;
        long result = context.globalIndex().expireAt(command.getKey(), currentTime + addTimeMillis);
        return Results.success().andReturn(Value.newLong(result));
    }
}

