/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import io.netty.buffer.ByteBuf;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.GetCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.string.NumberCache;
import kd.bos.xcache.server.store.data.string.StringCache;
import kd.bos.xcache.server.store.index.GlobalIndex;
import kd.bos.xcache.server.util.Longs;

public class GetCommandHandler
extends AbstractCommandHandler<GetCommand> {
    @Override
    public CommandType type() {
        return CommandType.GET;
    }

    @Override
    public Result doHandle(CommandContext context, GetCommand command) {
        GlobalIndex index = context.globalIndex();
        CacheObject cacheObject = index.find(command.getKey());
        if (null == cacheObject) {
            return Results.success().andReturnEmpty();
        }
        if (cacheObject instanceof NumberCache) {
            Value value = Value.newBytes(Longs.toStringBytes(((NumberCache)cacheObject).getValue()));
            return Results.success().andReturn(value);
        }
        if (cacheObject instanceof StringCache) {
            ByteBuf buffer = ((StringCache)cacheObject).getValue().buffer();
            Value value = Value.newBuffer(buffer);
            return Results.success().andReturn(value);
        }
        return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
    }
}

