/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.HDelCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.hash.HashCache;
import kd.bos.xcache.server.store.data.hash.HashData;

public class HDelCommandHandler
extends AbstractCommandHandler<HDelCommand> {
    @Override
    public CommandType type() {
        return CommandType.HDEL;
    }

    @Override
    public Result doHandle(CommandContext context, HDelCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturn(Values.LONG_FALSE);
        }
        if (!(cache instanceof HashCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        HashData hashData = ((HashCache)cache).getValue();
        long oldMemory = hashData.memSize();
        long removed = hashData.remove(command.getFields());
        long incrementMemory = (long)hashData.memSize() - oldMemory;
        context.globalIndex().updateMemory(command.getKey(), incrementMemory);
        if (hashData.size() == 0L) {
            context.globalIndex().remove(command.getKey());
        }
        return Results.success().andReturn(Value.newLong(removed));
    }
}

