/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.HExistsCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.hash.HashCache;

public class HExistsCommandHandler
extends AbstractCommandHandler<HExistsCommand> {
    @Override
    public CommandType type() {
        return CommandType.HEXISTS;
    }

    @Override
    public Result doHandle(CommandContext context, HExistsCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturn(Values.LONG_FALSE);
        }
        if (!(cache instanceof HashCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        Value r = ((HashCache)cache).getValue().exists(command.getField()) ? Values.LONG_TRUE : Values.LONG_FALSE;
        return Results.success().andReturn(r);
    }
}

