/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import java.util.LinkedList;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.HGetAllCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.store.data.hash.HashCache;
import kd.bos.xcache.server.store.data.hash.HashData;

public class HGetAllCommandHandler
extends AbstractCommandHandler<HGetAllCommand> {
    @Override
    public CommandType type() {
        return CommandType.HGETALL;
    }

    @Override
    public Result doHandle(CommandContext context, HGetAllCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturnEmptyArray();
        }
        if (!(cache instanceof HashCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        HashData hashData = ((HashCache)cache).getValue();
        LinkedList<Value> ret = new LinkedList<Value>();
        for (Key each : hashData.fields()) {
            ret.add(Values.KEY_2_VALUE.apply(each));
            ret.add(Values.BUFFER_2_VALUE.apply(hashData.get(each)));
        }
        return Results.success().andReturnArray(ret);
    }
}

