/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import java.util.Set;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.HKeysCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.store.data.hash.HashCache;

public class HKeysCommandHandler
extends AbstractCommandHandler<HKeysCommand> {
    @Override
    public CommandType type() {
        return CommandType.HKEYS;
    }

    @Override
    public Result doHandle(CommandContext context, HKeysCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturnEmptyArray();
        }
        if (!(cache instanceof HashCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        Set<Key> fields = ((HashCache)cache).getValue().fields();
        return Results.success().andReturnArray(Values.keys2List(fields));
    }
}

