/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.HSetCommand;
import kd.bos.xcache.server.cmd.model.param.FieldAndValue;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.DataFactory;
import kd.bos.xcache.server.store.data.hash.HashCache;
import kd.bos.xcache.server.store.data.hash.HashData;

public class HSetCommandHandler
extends AbstractCommandHandler<HSetCommand> {
    @Override
    public CommandType type() {
        return CommandType.HSET;
    }

    @Override
    public Result doHandle(CommandContext context, HSetCommand command) {
        return HSetCommandHandler.doHandle(context, command, true);
    }

    protected static Result doHandle(CommandContext context, HSetCommand command, boolean hasReturn) {
        FieldAndValue fieldAndValue;
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            cache = DataFactory.newHashCache();
            context.globalIndex().put(command.getKey(), cache);
        }
        if (!(cache instanceof HashCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        HashData hashData = ((HashCache)cache).getValue();
        long oldMemory = hashData.memSize();
        Value<Long> addCount = command.getFieldAndValueList().size() == 1 ? (hashData.put((fieldAndValue = command.getFieldAndValueList().get(0)).getField(), fieldAndValue.getValue()) ? Value.LONG_ONE : Value.LONG_ZERO) : Value.newLong(hashData.put(command.getFieldAndValueList()));
        long incrementMemory = (long)hashData.memSize() - oldMemory;
        context.globalIndex().updateMemory(command.getKey(), incrementMemory);
        return hasReturn ? Results.success().andReturn(addCount) : Results.success().andReturnOperationOK();
    }
}

