/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.IncrbyCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.DataFactory;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.store.data.string.NumberCache;
import kd.bos.xcache.server.store.data.string.StringCache;
import kd.bos.xcache.server.store.index.GlobalIndex;
import kd.bos.xcache.server.util.Longs;

public class IncrbyCommandHandler
extends AbstractCommandHandler<IncrbyCommand> {
    @Override
    public CommandType type() {
        return CommandType.INCRBY;
    }

    @Override
    public Result doHandle(CommandContext context, IncrbyCommand command) {
        return IncrbyCommandHandler.doIncr(context, command.getKey(), command.getIncrement());
    }

    protected static Result doIncr(CommandContext context, Key key, long inc) {
        GlobalIndex index = context.globalIndex();
        CacheObject cacheObject = index.find(key);
        if (null == cacheObject) {
            cacheObject = DataFactory.newNumberCache(inc);
            index.put(key, cacheObject);
            return Results.success().andReturn(Value.newLong(inc));
        }
        if (cacheObject instanceof NumberCache) {
            NumberCache numberCache = (NumberCache)cacheObject;
            if (Longs.isAdditionOverflow(numberCache.getValue(), inc)) {
                return Results.failed().andError(ErrorCode.COMMAND_INVOKE_INCREMENT_OVERFLOW, new String[0]);
            }
            long r = numberCache.increment(inc);
            return Results.success().andReturn(Value.newLong(r));
        }
        if (cacheObject instanceof StringCache) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_INCREMENT_STRING, new String[0]);
        }
        return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
    }
}

