/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.LIndexCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.list.ListCache;
import kd.bos.xcache.server.store.data.list.ListData;

public class LIndexCommandHandler
extends AbstractCommandHandler<LIndexCommand> {
    @Override
    public CommandType type() {
        return CommandType.LINDEX;
    }

    @Override
    public Result doHandle(CommandContext context, LIndexCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturnEmpty();
        }
        if (!(cache instanceof ListCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        ListData listData = ((ListCache)cache).getValue();
        Value result = Values.BUFFER_2_VALUE.apply(listData.get(command.getIndex()));
        return Results.success().andReturn(result);
    }
}

