/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.LSetCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.list.ListCache;
import kd.bos.xcache.server.store.data.list.ListData;

public class LSetCommandHandler
extends AbstractCommandHandler<LSetCommand> {
    @Override
    public CommandType type() {
        return CommandType.LSET;
    }

    @Override
    public Result doHandle(CommandContext context, LSetCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_KEY_NOT_EXISTS, new String[0]);
        }
        if (!(cache instanceof ListCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        ListData listData = ((ListCache)cache).getValue();
        try {
            long oldMemory = listData.memSize();
            listData.set(command.getIndex(), command.getElement());
            long incrementMemory = (long)listData.memSize() - oldMemory;
            context.globalIndex().updateMemory(command.getKey(), incrementMemory);
            return Results.success().andReturnOperationOK();
        }
        catch (IndexOutOfBoundsException e) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_INDEX_OUT_OF_RANGE, e.getMessage());
        }
    }
}

