/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.MemoryUsageCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.index.GlobalIndex;

public class MemoryUsageCommandHandler
extends AbstractCommandHandler<MemoryUsageCommand> {
    @Override
    public CommandType type() {
        return CommandType.MEMORY_USAGE;
    }

    @Override
    public Result doHandle(CommandContext context, MemoryUsageCommand command) {
        if (command.getCount().isPresent() && command.getCount().get() < 0L) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_INTEGER_SHOULD_NEGATIVE_OR_ZERO, "count");
        }
        GlobalIndex index = context.globalIndex();
        CacheObject cacheObject = index.find(command.getKey());
        if (null == cacheObject) {
            return Results.success().andReturnEmpty();
        }
        return Results.success().andReturn(Value.newLong(command.getKey().memSize() + cacheObject.memSize()));
    }
}

