/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.SCardCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.set.SetCache;

public class SCardCommandHandler
extends AbstractCommandHandler<SCardCommand> {
    @Override
    public CommandType type() {
        return CommandType.SCARD;
    }

    @Override
    public Result doHandle(CommandContext context, SCardCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturn(Values.LONG_EMPTY);
        }
        if (!(cache instanceof SetCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        return Results.success().andReturn(Value.newLong(cache.length()));
    }
}

