/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.xcache.server.cmd.model.NoKeyCommand;
import kd.bos.xcache.server.cmd.model.anntation.OptionParameter;
import kd.bos.xcache.server.cmd.model.anntation.OrderParameter;
import kd.bos.xcache.server.protocol.CommandType;

public class ScanCommand
extends NoKeyCommand {
    private static final String OPTION_MATCH = "MATCH";
    private static final String OPTION_COUNT = "COUNT";
    private static final String OPTION_TYPE = "TYPE";
    private static final String OPTION_MEMORY = "MEMORY";
    @OrderParameter(order=2)
    private long cursor;
    @OptionParameter(option="MATCH")
    private Optional<String> pattern;
    @OptionParameter(option="COUNT")
    private Optional<Long> count;
    @OptionParameter(option="TYPE")
    private Optional<String> type;
    @OptionParameter(option="MEMORY")
    private Optional<String> memory;

    public ScanCommand() {
    }

    public ScanCommand(long cursor, Optional<String> pattern, Optional<Long> count, Optional<String> type, Optional<String> memory) {
        this.cursor = cursor;
        this.pattern = pattern;
        this.count = count;
        this.type = type;
        this.memory = memory;
    }

    public long getCursor() {
        return this.cursor;
    }

    public Optional<String> getPattern() {
        return this.pattern;
    }

    public Optional<Long> getCount() {
        return this.count;
    }

    public Optional<String> getType() {
        return this.type;
    }

    public Optional<String> getMemory() {
        return this.memory;
    }

    @Override
    public CommandType type() {
        return CommandType.SCAN;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public List<Object> args() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.cursor);
        if (this.pattern.isPresent()) {
            args.add(OPTION_MATCH);
            args.add(this.pattern.get());
        }
        if (this.count.isPresent()) {
            args.add(OPTION_COUNT);
            args.add(this.count.get());
        }
        if (this.type.isPresent()) {
            args.add(OPTION_TYPE);
            args.add(this.type.get());
        }
        if (this.memory.isPresent()) {
            args.add(OPTION_MEMORY);
            args.add(this.memory.get());
        }
        return args;
    }

    @Override
    public String toString() {
        return String.format("%s[cursor=%s]", this.getClass().getSimpleName(), this.cursor);
    }
}

