/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.parser;

import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.xcache.server.cmd.parser.OptionParameterMetadata;
import kd.bos.xcache.server.cmd.parser.OrderParameterMetadata;
import kd.bos.xcache.server.cmd.parser.ParameterType;

public class CompParamMetadata<T> {
    private final Class<T> parameterClass;
    private final List<OrderParameterMetadata> orderParameters;
    private final LinkedHashMap<String, OptionParameterMetadata> optionParameters;
    private final int maxOptionLen;

    public CompParamMetadata(Class<T> parameterClass, List<OrderParameterMetadata> orderParameters, LinkedHashMap<String, OptionParameterMetadata> optionParameters) {
        this.parameterClass = parameterClass;
        this.orderParameters = orderParameters;
        this.optionParameters = optionParameters;
        this.maxOptionLen = this.generateMaxOptionLen(optionParameters);
    }

    private int generateMaxOptionLen(LinkedHashMap<String, OptionParameterMetadata> optionParameters) {
        return optionParameters.isEmpty() ? 0 : optionParameters.keySet().stream().mapToInt(String::length).max().getAsInt();
    }

    public LinkedHashMap<String, OptionParameterMetadata> getOptionParameters() {
        return this.optionParameters;
    }

    public int getMaxOptionLen() {
        return this.maxOptionLen;
    }

    protected String parameterUsage() {
        return String.format("%s%s", this.orderParameterUsage(this.orderParameters), this.optionParameterUsage(this.optionParameters));
    }

    private String optionParameterUsage(LinkedHashMap<String, OptionParameterMetadata> parameters) {
        StringBuilder sb = new StringBuilder();
        for (OptionParameterMetadata each : parameters.values()) {
            sb.append(" ");
            sb.append(this.atomicOptionParameterUsage(each));
        }
        return sb.toString();
    }

    private String atomicOptionParameterUsage(OptionParameterMetadata each) {
        return String.format("%s %s", each.getOption(), each.getDisplayName());
    }

    private String orderParameterUsage(List<OrderParameterMetadata> parameters) {
        StringBuilder sb = new StringBuilder();
        for (OrderParameterMetadata each : parameters) {
            sb.append(" ");
            sb.append(this.orderParameterUsage(each));
        }
        return sb.toString();
    }

    private String orderParameterUsage(OrderParameterMetadata each) {
        if (each.isList()) {
            return String.format("%s[%s ...]", each.isOptional() ? "" : this.atomicOrderParameterUsage(each) + " ", this.atomicOrderParameterUsage(each));
        }
        return each.isOptional() ? String.format("[%s]", this.atomicOrderParameterUsage(each)) : this.atomicOrderParameterUsage(each);
    }

    private String atomicOrderParameterUsage(OrderParameterMetadata each) {
        if (ParameterType.COMPOSITE == each.getValueType()) {
            return this.orderParameterUsage(each.getCompParamMetadata().getOrderParameters()).trim();
        }
        return each.getDisplayName();
    }

    public Class<T> getParameterClass() {
        return this.parameterClass;
    }

    public List<OrderParameterMetadata> getOrderParameters() {
        return this.orderParameters;
    }
}

