/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.parser;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.cmd.model.anntation.BooleanSelector;
import kd.bos.xcache.server.cmd.model.anntation.CompositeParameter;
import kd.bos.xcache.server.cmd.model.anntation.OptionParameter;
import kd.bos.xcache.server.cmd.model.anntation.OrderParameter;
import kd.bos.xcache.server.cmd.parser.BoolParamMetadata;
import kd.bos.xcache.server.cmd.parser.CommandMetadata;
import kd.bos.xcache.server.cmd.parser.CompParamMetadata;
import kd.bos.xcache.server.cmd.parser.OptionParameterMetadata;
import kd.bos.xcache.server.cmd.parser.OrderParameterMetadata;
import kd.bos.xcache.server.cmd.parser.ParameterType;
import kd.bos.xcache.server.exception.CacheServerRuntimeException;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.exception.InvalidArgumentException;
import kd.bos.xcache.server.exception.UnExceptedException;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.util.Fields;

public class MetadataBuilder {
    private MetadataBuilder() {
    }

    public static <T extends Command> CommandMetadata<T> build(T command) {
        Class<?> clazz = command.getClass();
        Map<String, Field> fieldMap = Fields.getFields(clazz);
        try {
            List<OrderParameterMetadata> metadataList = MetadataBuilder.generateMetadata(fieldMap);
            LinkedHashMap<String, OptionParameterMetadata> optionParameterMetadataMap = MetadataBuilder.generateOrderParameters(fieldMap);
            return new CommandMetadata(command.type(), clazz, metadataList, optionParameterMetadataMap);
        }
        catch (ClassNotFoundException e) {
            throw new UnExceptedException(e, String.format("error when generate metadata for %s", clazz.getName()));
        }
    }

    private static List<OrderParameterMetadata> generateMetadata(Map<String, Field> fieldMap) throws ClassNotFoundException {
        HashMap<Integer, OrderParameterMetadata> metadataMap = new HashMap<Integer, OrderParameterMetadata>(fieldMap.size());
        for (Field field : fieldMap.values()) {
            OrderParameter parameter = field.getAnnotation(OrderParameter.class);
            if (null == parameter) continue;
            Type filedType = MetadataBuilder.getRealType(field);
            OrderParameterMetadata metadata = new OrderParameterMetadata(parameter.order(), MetadataBuilder.isOptional(field), parameter.displayName(), field, MetadataBuilder.isList(field), MetadataBuilder.getParameterValueType(filedType));
            if (ParameterType.BOOLEAN == metadata.getValueType()) {
                BooleanSelector booleanSelector = field.getAnnotation(BooleanSelector.class);
                if (null == booleanSelector) {
                    throw new CacheServerRuntimeException(ErrorCode.ERROR, String.format("Boolean field[%s] should has annotation [%s]", field.getName(), BooleanSelector.class.getSimpleName()));
                }
                metadata.setBoolParamMetadata(BoolParamMetadata.create(booleanSelector));
            }
            if (ParameterType.COMPOSITE == metadata.getValueType()) {
                Class<?> realTypeClass = Class.forName(filedType.getTypeName());
                Map<String, Field> parameterFields = Fields.getFields(realTypeClass);
                List<OrderParameterMetadata> orderParameterMetadataList = MetadataBuilder.generateMetadata(parameterFields);
                LinkedHashMap<String, OptionParameterMetadata> optionParameterMetadataMap = MetadataBuilder.generateOrderParameters(parameterFields);
                metadata.setCompParamMetadata(new CompParamMetadata(realTypeClass, orderParameterMetadataList, optionParameterMetadataMap));
            }
            if (metadataMap.containsKey(metadata.getOrder())) {
                throw new InvalidArgumentException(String.format("Duplicate order %s with %s and %s.", metadata.getOrder(), metadata.getFieldName(), ((OrderParameterMetadata)metadataMap.get(metadata.getOrder())).getFieldName()));
            }
            metadataMap.put(metadata.getOrder(), metadata);
        }
        return metadataMap.keySet().stream().sorted().map(metadataMap::get).collect(Collectors.toList());
    }

    private static LinkedHashMap<String, OptionParameterMetadata> generateOrderParameters(Map<String, Field> fieldMap) throws ClassNotFoundException {
        LinkedHashMap<String, OptionParameterMetadata> result = new LinkedHashMap<String, OptionParameterMetadata>();
        for (Field field : fieldMap.values()) {
            OptionParameter parameter = field.getAnnotation(OptionParameter.class);
            if (null == parameter) continue;
            Type filedType = MetadataBuilder.getRealType(field);
            OptionParameterMetadata metadata = new OptionParameterMetadata(parameter.option(), field, MetadataBuilder.getParameterValueType(filedType));
            if (result.containsKey(metadata.getOption())) {
                throw new InvalidArgumentException(String.format("Duplicate option %s with %s and %s.", metadata.getOption(), metadata.getFieldName(), result.get(metadata.getOption()).getFieldName()));
            }
            result.put(metadata.getOption(), metadata);
        }
        return result;
    }

    private static Type getRealType(Field field) {
        if (MetadataBuilder.isList(field) || MetadataBuilder.isOptional(field)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            return parameterizedType.getActualTypeArguments()[0];
        }
        return field.getType();
    }

    private static ParameterType getParameterValueType(Type type) throws ClassNotFoundException {
        String name = type.getTypeName();
        if (name.equals("long") || Long.class.getName().equals(name)) {
            return ParameterType.LONG;
        }
        if (name.equals(Key.class.getName())) {
            return ParameterType.KEY;
        }
        if (name.equals(BufferString.class.getName())) {
            return ParameterType.BUFFER_STRING;
        }
        if (name.equals(String.class.getName())) {
            return ParameterType.STRING;
        }
        if (name.equals("boolean") || Boolean.class.getName().equals(name)) {
            return ParameterType.BOOLEAN;
        }
        CompositeParameter compositeParameter = MetadataBuilder.tryGetCompositeParameter(type);
        if (compositeParameter != null) {
            return ParameterType.COMPOSITE;
        }
        throw new CacheServerRuntimeException(ErrorCode.ERROR, "Unknown parameter type " + type);
    }

    private static CompositeParameter tryGetCompositeParameter(Type type) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(type.getTypeName());
        return clazz.getAnnotation(CompositeParameter.class);
    }

    private static boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private static boolean isOptional(Field field) {
        return field.getType().isAssignableFrom(Optional.class);
    }
}

