/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.common;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RingBuffer<T> {
    private AtomicLong index = new AtomicLong(0L);
    private final Object[] data;
    private final int size;
    private final ReadWriteLock readWriteLock;

    public RingBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size need be positive number");
        }
        this.size = size;
        this.data = new Object[size];
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T item) {
        long i = this.index.getAndIncrement();
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            this.data[(int)(i % (long)this.size)] = item;
        }
        finally {
            lock.unlock();
        }
    }

    public void clean() {
        this.index.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> get(int count) {
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            List<T> list = this.getDataInOrder(count >= 0 ? count : this.size);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    public int size() {
        long i = this.index.get();
        return i < (long)this.size ? (int)i : this.size;
    }

    private List<T> getDataInOrder(int count) {
        int last;
        int capacity;
        long current = this.index.get();
        if (current < (long)this.size) {
            capacity = (int)current;
            last = capacity - 1;
        } else {
            capacity = this.size;
            last = (int)(current - 1L) % this.size;
        }
        capacity = Math.min(capacity, count);
        ArrayList<Object> result = new ArrayList<Object>(capacity);
        for (int i = 0; i < capacity; ++i) {
            result.add(this.data[last]);
            last = (last + this.size - 1) % this.size;
        }
        return result;
    }
}

