/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.common;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SetFuture<T> {
    private T item;
    private boolean hasValue = false;
    private final Lock lock = new ReentrantLock();
    private final Condition itemAvailable = this.lock.newCondition();

    public void set(T newItem) {
        this.lock.lock();
        try {
            if (this.hasValue) {
                throw new IllegalStateException("Value has already been set: " + this.item.getClass() + " new item: " + newItem.getClass());
            }
            this.item = newItem;
            this.hasValue = true;
            this.itemAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T get() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.hasValue) {
                this.itemAvailable.await();
            }
            T t = this.item;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T getDirct() {
        this.lock.lock();
        try {
            T t = this.item;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

