/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.common.registry;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.xcache.server.common.registry.Registry;
import kd.bos.xcache.server.exception.UnExceptedException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public abstract class AbstractRegistry<K, V>
implements Registry<K, V> {
    private final Map<K, V> cache = new HashMap();

    protected AbstractRegistry(Function<V, K> keyMapper, Class<V> valueClass) {
        this(keyMapper, valueClass, null);
    }

    protected AbstractRegistry(Function<V, K> keyMapper, Class<V> valueClass, Function<Class<? extends V>, V> creator) {
        try {
            String packageName = valueClass.getPackage().getName();
            Reflections reflections = new Reflections(packageName, new Scanner[0]);
            Set allFoundClass = reflections.getSubTypesOf(valueClass);
            for (Class clazz : allFoundClass) {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                Object v = creator == null ? clazz.newInstance() : creator.apply(clazz);
                this.cache.put(keyMapper.apply(v), v);
            }
        }
        catch (Exception e) {
            throw new UnExceptedException(e, String.format("%s error occurred when find implements of %s", e.getClass().getSimpleName(), valueClass.getSimpleName()));
        }
    }

    @Override
    public V find(K key) {
        return this.cache.get(key);
    }

    public Collection<K> keys() {
        return this.cache.keySet();
    }
}

