/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.dispatch;

import java.util.List;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.dispatch.DispatchCenter;
import kd.bos.xcache.server.dispatch.exec.ExecuteUnitTask;
import kd.bos.xcache.server.dispatch.route.CommandRouter;
import kd.bos.xcache.server.dispatch.route.RouteUnit;
import kd.bos.xcache.server.executor.Task;
import kd.bos.xcache.server.executor.TaskExecutor;
import kd.bos.xcache.server.net.ClientInfo;
import kd.bos.xcache.server.result.handler.TailResultHandler;
import kd.bos.xcache.server.store.index.GlobalIndex;
import kd.bos.xcache.server.util.Sizes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionDispatchCenter
implements DispatchCenter {
    private static final Logger log = LoggerFactory.getLogger(PartitionDispatchCenter.class);
    private final GlobalIndex[] indexs;
    private final TaskExecutor taskExecutor;
    private final CommandRouter router;
    private volatile boolean isOpened;

    public PartitionDispatchCenter(long maxMemorySize, int size, TaskExecutor taskExecutor) {
        this.indexs = PartitionDispatchCenter.initIndexes(size, maxMemorySize);
        this.taskExecutor = taskExecutor;
        this.router = CommandRouter.newDefaultRouter(size);
    }

    private static GlobalIndex[] initIndexes(int size, long maxMemorySize) {
        GlobalIndex[] result = new GlobalIndex[size];
        for (int i = 0; i < size; ++i) {
            result[i] = GlobalIndex.newIndex(maxMemorySize);
        }
        return result;
    }

    private GlobalIndex getIndex(int partitionIndex) {
        return this.indexs[partitionIndex];
    }

    private void executeAt(Task task) {
        this.taskExecutor.submit(task);
    }

    @Override
    public void open() {
        if (this.isOpened) {
            return;
        }
        this.taskExecutor.start();
        this.isOpened = true;
        if (log.isInfoEnabled()) {
            log.info(String.format("Dispatch center start with %s partitions and %s memory per partition.", this.indexs.length, Sizes.format(this.indexs[0].getMaxMemorySize())));
        }
    }

    @Override
    public void close() {
        if (this.isOpened) {
            this.taskExecutor.shutdown();
        }
    }

    @Override
    public void execute(ClientInfo clientInfo, Command command, TailResultHandler tailHandler) {
        List<RouteUnit> unitList = this.router.route(command);
        for (RouteUnit routeUnit : unitList) {
            CommandContext context = CommandContext.newPartitionContext(this.indexs, clientInfo, this.getIndex(routeUnit.getIndex()));
            ExecuteUnitTask task = ExecuteUnitTask.create(context, routeUnit.getExecuteUnit(), tailHandler);
            this.executeAt(task);
        }
    }
}

