/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.dispatch.exec;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.xcache.server.cmd.CommandCenter;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.CommandHandler;
import kd.bos.xcache.server.dispatch.exec.ExecuteUnit;
import kd.bos.xcache.server.exception.CacheServerRuntimeException;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.executor.Task;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.handler.ResultHandler;
import kd.bos.xcache.server.result.handler.SlowLogHandler;
import kd.bos.xcache.server.result.handler.TailResultHandler;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.slowlog.SlowLogManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteUnitTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(ExecuteUnitTask.class);
    private CommandContext context;
    private ExecuteUnit executeUnit;
    private TailResultHandler tailResultHandler;

    private ExecuteUnitTask(CommandContext context, ExecuteUnit executeUnit, TailResultHandler tailResultHandler) {
        this.context = context;
        this.executeUnit = executeUnit;
        this.tailResultHandler = tailResultHandler;
    }

    public static ExecuteUnitTask create(CommandContext context, ExecuteUnit executeUnit, TailResultHandler tailResultHandler) {
        return new ExecuteUnitTask(context, executeUnit, tailResultHandler);
    }

    @Override
    public void run() {
        this.executeUnit.getCommand().retain();
        try {
            this.executeAndHandleResults();
        }
        finally {
            this.executeUnit.getCommand().release();
        }
    }

    private void executeAndHandleResults() {
        Result result;
        try {
            if (SlowLogManger.isEnable() && !this.executeUnit.getCommand().type().isInnerCommand()) {
                this.executeUnit.getPipeline().add(new SlowLogHandler(this.context.client(), this.executeUnit.getCommand()));
            }
            this.executeUnit.getPipeline().add(this.tailResultHandler.asResultHandler());
            CommandHandler commandHandler = CommandCenter.getHandler(this.executeUnit.getCommand().type());
            result = commandHandler.handle(this.context, this.executeUnit.getCommand());
        }
        catch (CacheServerRuntimeException e) {
            result = Results.failed().andError(e.getErrorCode().getCode(), e.getMessage());
        }
        catch (Throwable e) {
            result = Results.failed().andError(ErrorCode.ERROR, e.getMessage());
            log.warn(String.format("Error when execute task: %s", e.getMessage()), e);
        }
        try {
            this.handleResults(this.executeUnit.getPipeline(), Collections.singletonList(result));
        }
        catch (Throwable e) {
            log.warn(String.format("Error when handle results: %s", e.getMessage()), e);
            this.tailResultHandler.handle(Results.failed().andError(ErrorCode.ERROR, e.getMessage()));
        }
    }

    void handleResults(List<ResultHandler> handlers, List<Result> results) {
        ArrayDeque<Frame> stack = new ArrayDeque<Frame>();
        stack.push(new Frame(0, results));
        while (!stack.isEmpty()) {
            Frame frame = (Frame)stack.pop();
            int current = frame.current;
            List<Result> currentResults = frame.results;
            if (current >= handlers.size() || currentResults.isEmpty()) continue;
            ResultHandler resultHandler = handlers.get(current);
            for (Result result : currentResults) {
                LinkedList<Result> out = new LinkedList<Result>();
                resultHandler.handle(result, out);
                stack.push(new Frame(current + 1, out));
            }
        }
    }

    private static class Frame {
        int current;
        List<Result> results;

        Frame(int current, List<Result> results) {
            this.current = current;
            this.results = results;
        }
    }
}

