/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.dispatch.route;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.cmd.model.MultiKeyCommand;
import kd.bos.xcache.server.cmd.model.NoKeyCommand;
import kd.bos.xcache.server.cmd.model.SingleKeyCommand;
import kd.bos.xcache.server.dispatch.route.CommandRouter;
import kd.bos.xcache.server.dispatch.route.KeyHashRouteStrategy;
import kd.bos.xcache.server.dispatch.route.RoundRobinRouteStrategy;
import kd.bos.xcache.server.dispatch.route.RouteStrategy;
import kd.bos.xcache.server.dispatch.route.RouteUnit;
import kd.bos.xcache.server.result.handler.ResultMergeHandler;
import kd.bos.xcache.server.store.data.Key;

public class DefaultCommandRouterImpl
implements CommandRouter {
    private final int partitionSize;
    private final RouteStrategy hashStrategy;
    private final RouteStrategy roundRobinStrategy;

    public DefaultCommandRouterImpl(int partitionSize) {
        this.partitionSize = partitionSize;
        this.hashStrategy = new KeyHashRouteStrategy(partitionSize);
        this.roundRobinStrategy = new RoundRobinRouteStrategy(partitionSize);
    }

    @Override
    public List<RouteUnit> route(Command command) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        if (command instanceof SingleKeyCommand) {
            this.routeSingleKeyCommand(result, (SingleKeyCommand)command);
        } else if (command instanceof MultiKeyCommand) {
            this.routeMultiKeyCommand(result, (MultiKeyCommand)command);
        } else {
            this.routeNoKeyCommand(result, (NoKeyCommand)command);
        }
        return result;
    }

    private void routeMultiKeyCommand(List<RouteUnit> units, MultiKeyCommand command) {
        HashMap<Integer, LinkedList<Key>> routeResultMap = new HashMap<Integer, LinkedList<Key>>();
        for (Key key : command.getKeys()) {
            int index = this.hashStrategy.route(key);
            LinkedList<Key> keyList = (LinkedList<Key>)routeResultMap.get(index);
            if (null == keyList) {
                keyList = new LinkedList<Key>();
                routeResultMap.put(index, keyList);
            }
            keyList.add(key);
        }
        ResultMergeHandler mergeHandler = new ResultMergeHandler(routeResultMap.size(), command.resultSumAble());
        for (Map.Entry each : routeResultMap.entrySet()) {
            RouteUnit unit = RouteUnit.create((Integer)each.getKey(), command.spilt((List)each.getValue()));
            unit.pipeline().add(mergeHandler);
            units.add(unit);
        }
    }

    private void routeNoKeyCommand(List<RouteUnit> units, NoKeyCommand command) {
        if (command.isBroadcast()) {
            this.doBroadcast(units, command);
        } else {
            this.routeByRoundRobin(units, command);
        }
    }

    private void routeByRoundRobin(List<RouteUnit> units, Command command) {
        this.doRoute(units, command, this.roundRobinStrategy, null);
    }

    private void routeSingleKeyCommand(List<RouteUnit> units, SingleKeyCommand command) {
        this.doRoute(units, command, this.hashStrategy, command.getKey());
    }

    private void doRoute(List<RouteUnit> units, Command command, RouteStrategy strategy, Key key) {
        units.add(RouteUnit.create(strategy.route(key), command));
    }

    private void doBroadcast(List<RouteUnit> units, NoKeyCommand command) {
        ResultMergeHandler mergeHandler = new ResultMergeHandler(this.partitionSize, command.resultSumAble());
        for (int i = 0; i < this.partitionSize; ++i) {
            RouteUnit unit = RouteUnit.create(i, command);
            unit.pipeline().add(mergeHandler);
            units.add(unit);
        }
    }
}

