/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.env;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import kd.bos.xcache.server.env.Environment;

public class HostingEnvironment
implements Environment {
    public static final String XCACHE_HOSTING_MODE = "hosting";

    public static HostingEnvironment get() {
        return HostingEnvironmentHolder.INSTANCE;
    }

    @Override
    public MetricRegistry metricRegistry() {
        return MetricRegistryHolder.INSTANCE;
    }

    @Override
    public String mode() {
        return XCACHE_HOSTING_MODE;
    }

    private HostingEnvironment() {
    }

    private static class HostingEnvironmentHolder {
        private static final HostingEnvironment INSTANCE = new HostingEnvironment();

        private HostingEnvironmentHolder() {
        }
    }

    private static class MetricRegistryHolder {
        private static final MetricRegistry INSTANCE = new MetricRegistry();

        private MetricRegistryHolder() {
        }

        static {
            INSTANCE.register(String.format("%s%s", "kd.metrics", ".jvm.gc"), (Metric)new GarbageCollectorMetricSet());
            INSTANCE.register(String.format("%s%s", "kd.metrics", ".jvm.memory"), (Metric)new MemoryUsageGaugeSet());
            JmxReporter.forRegistry((MetricRegistry)INSTANCE).inDomain("kd.metrics").build();
        }
    }
}

