/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.invoker.impl;

import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.dispatch.DispatchCenter;
import kd.bos.xcache.server.exception.CommandInvokeException;
import kd.bos.xcache.server.invoker.CommandInvoker;
import kd.bos.xcache.server.invoker.InvokeFailedHandler;
import kd.bos.xcache.server.invoker.InvokeSuccessHandler;
import kd.bos.xcache.server.net.ClientInfo;
import kd.bos.xcache.server.result.model.Result;

abstract class AbstractCommandInvoker<T>
implements CommandInvoker<T> {
    private DispatchCenter dispatchCenter;
    private Command command;

    protected AbstractCommandInvoker(DispatchCenter dispatchCenter, Command command) {
        this.dispatchCenter = dispatchCenter;
        this.command = command;
    }

    @Override
    public void invoke(InvokeFailedHandler errorHandler, InvokeSuccessHandler<T> successHandler) {
        this.dispatchCenter.execute(ClientInfo.LOCAL, this.command, result -> {
            try {
                if (!result.isSuccess()) {
                    errorHandler.onError(new CommandInvokeException(String.format("status: %s, error: %s", result.getStatus(), result.getError())));
                } else {
                    successHandler.onSuccess(this.extractValue(result));
                }
            }
            finally {
                result.release();
            }
        });
    }

    protected abstract T extractValue(Result var1);
}

