/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.invoker.wrapper;

import kd.bos.xcache.server.exception.CommandInvokeException;
import kd.bos.xcache.server.invoker.CommandInvoker;
import kd.bos.xcache.server.invoker.InvokeFailedHandler;
import kd.bos.xcache.server.invoker.InvokeSuccessHandler;
import kd.bos.xcache.server.invoker.wrapper.AsyncOnErrorInvokeWrapper;
import kd.bos.xcache.server.invoker.wrapper.AsyncOnSuccessInvokeWrapper;
import kd.bos.xcache.server.invoker.wrapper.CommandInvokerWrapper;
import kd.bos.xcache.server.invoker.wrapper.ResultHolderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullCommandInvokerWrapper<T>
implements CommandInvokerWrapper {
    private static final Logger log = LoggerFactory.getLogger(FullCommandInvokerWrapper.class);
    private final CommandInvoker<T> invoker;
    protected InvokeFailedHandler errorHandler;
    protected InvokeSuccessHandler<T> successHandler;
    static final InvokeFailedHandler JUST_LOGGER = e -> log.warn(e.getMessage());
    static final InvokeSuccessHandler<?> DO_NOTHING = v -> {};

    private FullCommandInvokerWrapper(CommandInvoker<T> invoker) {
        this.invoker = invoker;
    }

    public static <T> FullCommandInvokerWrapper<T> newWrapper(CommandInvoker<T> commandInvoker) {
        return new FullCommandInvokerWrapper<T>(commandInvoker);
    }

    public AsyncOnErrorInvokeWrapper<T> onError(InvokeFailedHandler errorHandler) {
        this.errorHandler = errorHandler;
        return new AsyncOnErrorInvokeWrapper(this);
    }

    public AsyncOnSuccessInvokeWrapper<T> onSuccess(InvokeSuccessHandler<T> successHandler) {
        this.successHandler = successHandler;
        return new AsyncOnSuccessInvokeWrapper(this);
    }

    @Override
    public void invoke() {
        this.invoker.invoke(this.errorHandler == null ? JUST_LOGGER : this.errorHandler, this.successHandler == null ? DO_NOTHING : this.successHandler);
    }

    public T invokeSync() throws CommandInvokeException {
        ResultHolderHandler resultHolderHandler = new ResultHolderHandler();
        this.invoker.invoke(resultHolderHandler, resultHolderHandler);
        return resultHolderHandler.get();
    }
}

