/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import kd.bos.xcache.server.ServerContext;
import kd.bos.xcache.server.cmd.CommandCenter;
import kd.bos.xcache.server.cmd.model.AuthCommand;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.exception.UnExceptedException;
import kd.bos.xcache.server.exception.UnsupportedCommandException;
import kd.bos.xcache.server.net.AttachmentKey;
import kd.bos.xcache.server.net.ClientInfo;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Request;
import kd.bos.xcache.server.protocol.Response;
import kd.bos.xcache.server.result.Results;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private ServerContext serverContext;
    private boolean needAuth;

    public RequestHandler(ServerContext serverContext) {
        this.serverContext = serverContext;
        this.needAuth = ServerPlatform.getRootPassword().length > 0;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Request)) {
            throw new UnExceptedException(String.format("Unknown msg type: %s", msg.getClass()));
        }
        Request request = (Request)msg;
        if (request.getCommand().isInnerCommand()) {
            throw new UnsupportedCommandException(request.getCommand().name());
        }
        Command command = CommandCenter.parse(request);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Command request: %s %s", new Object[]{command.type(), command}));
        }
        if (this.requestNeedAuth(ctx) && !this.isIgnoreAuthCommand(command)) {
            this.returnError(ctx, ErrorCode.AUTH_REQUIRED);
        } else if (CommandType.AUTH == command.type()) {
            this.handleAuthCommand(ctx, (AuthCommand)command);
        } else if (CommandType.QUIT == command.type()) {
            RequestHandler.handleQuitCommand(ctx);
        } else {
            this.handleCommonCommand(ctx, command);
        }
    }

    private void handleCommonCommand(ChannelHandlerContext ctx, Command command) {
        ClientInfo clientInfo = (ClientInfo)ctx.channel().attr(AttachmentKey.CLIENT_INFO).get();
        this.serverContext.getDispatchCenter().execute(clientInfo, command, result -> ctx.channel().writeAndFlush((Object)Results.convertors().convert2Response(result)));
    }

    private static void handleQuitCommand(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)Response.NOT_VALUE_SUCCESS).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void handleAuthCommand(ChannelHandlerContext ctx, AuthCommand command) {
        if (!this.needAuth) {
            this.returnError(ctx, ErrorCode.AUTH_NO_NEED);
            return;
        }
        boolean passwordOk = Arrays.equals(command.getPassword().getBytes(), ServerPlatform.getRootPassword());
        if (passwordOk) {
            ctx.channel().attr(AttachmentKey.AUTHED).set((Object)Boolean.TRUE);
            RequestHandler.returnSuccess(ctx);
        } else {
            ctx.channel().attr(AttachmentKey.AUTHED).set(null);
            this.returnError(ctx, ErrorCode.AUTH_PASSWORD_ERROR);
        }
    }

    private static void returnSuccess(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)Response.NOT_VALUE_SUCCESS);
    }

    private void returnError(ChannelHandlerContext ctx, ErrorCode errorCode) {
        ctx.writeAndFlush((Object)Response.error(errorCode, new String[0]));
    }

    private boolean isIgnoreAuthCommand(Command command) {
        return command.type().noAuth();
    }

    private boolean requestNeedAuth(ChannelHandlerContext ctx) {
        return this.needAuth && ctx.channel().attr(AttachmentKey.AUTHED).get() == null;
    }
}

