/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.redis.ArrayHeaderRedisMessage;
import io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import io.netty.handler.codec.redis.BulkStringRedisContent;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.LastBulkStringRedisContent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import kd.bos.xcache.server.common.Releasable;
import kd.bos.xcache.server.exception.CommandInvalidException;
import kd.bos.xcache.server.exception.CommandNeedSubCommandException;
import kd.bos.xcache.server.exception.CommandWrongSubCommandException;
import kd.bos.xcache.server.exception.UnsupportedCommandException;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Request;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.util.ArgumentUtil;
import kd.bos.xcache.server.util.ByteBufUtil;

public class RedisRequestBuilder
implements Releasable {
    private ByteBufAllocator allocator;
    private long arraySize;
    private String mainCommand;
    private String subCommand;
    private List<ByteBuf> args = new LinkedList<ByteBuf>();
    private CompositeByteBuf nextContents;
    private long acceptedSize = 0L;
    private boolean isCompleted = false;
    public static final int MAX_BYTE_BUF_COMPONENTS_SIZE = 1024;
    public static final int MAX_BYTE_PER_COMPONENTS_SIZE = 10240;

    public RedisRequestBuilder(ByteBufAllocator allocator, long arraySize) {
        this.allocator = allocator;
        this.arraySize = arraySize;
    }

    public static RedisRequestBuilder builder(ByteBufAllocator allocator, ArrayHeaderRedisMessage arrayHeader) {
        return new RedisRequestBuilder(allocator, arrayHeader.length());
    }

    public void nextBulkHeader(BulkStringHeaderRedisMessage bulkStringHeader) {
        int maxComponents = Math.max(bulkStringHeader.bulkStringLength() / 10240, 1024);
        this.nextContents = this.allocator.compositeBuffer(maxComponents);
    }

    public void nextBulkContent(BulkStringRedisContent bulkContent) {
        ByteBuf content = bulkContent.content();
        if (bulkContent instanceof FullBulkStringRedisMessage) {
            this.nextContents = this.allocator.compositeBuffer(1024);
            this.nextContents.writeBytes(content);
            this.addContent();
        } else {
            this.nextContents.writeBytes(content);
            if (bulkContent instanceof LastBulkStringRedisContent) {
                this.addContent();
            }
        }
    }

    private void addContent() {
        if (this.mainCommand == null || this.subCommand == null && CommandType.hasSubCommand(this.mainCommand)) {
            this.buildCommand();
        } else {
            this.args.add((ByteBuf)this.nextContents);
        }
        this.nextContents = null;
        ++this.acceptedSize;
    }

    private void buildCommand() {
        if (this.mainCommand == null) {
            String firstCommand = this.contentAsCommand();
            String[] parts = RedisRequestBuilder.spiltCommands(firstCommand);
            this.mainCommand = parts[0];
            if (parts.length > 1) {
                this.subCommand = parts[1];
            }
        } else {
            this.subCommand = this.contentAsCommand();
        }
    }

    static String[] spiltCommands(String input) {
        String trimInput = input.trim();
        int spiltOffset = -1;
        for (int i = 0; i < trimInput.length(); ++i) {
            if (!Character.isWhitespace(trimInput.charAt(i))) continue;
            spiltOffset = i;
            break;
        }
        if (spiltOffset <= 0) {
            return new String[]{trimInput};
        }
        return new String[]{trimInput.substring(0, spiltOffset), trimInput.substring(spiltOffset + 1).trim()};
    }

    private String contentAsCommand() {
        int len = this.nextContents.readableBytes();
        ArgumentUtil.checkBound(len, 1L, 128L, "command length");
        byte[] data = new byte[this.nextContents.readableBytes()];
        this.nextContents.readBytes(data);
        ByteBufUtil.release((ByteBuf)this.nextContents);
        return new String(data);
    }

    public boolean isDone() {
        return this.acceptedSize >= this.arraySize;
    }

    public synchronized Request build() throws UnsupportedCommandException, CommandInvalidException {
        Optional<CommandType> command;
        if (!CommandType.hasSubCommand(this.mainCommand)) {
            command = CommandType.findCommandType(this.mainCommand);
        } else {
            if (this.subCommand == null) {
                throw new CommandNeedSubCommandException(this.mainCommand.toUpperCase());
            }
            command = CommandType.findCommandType(this.mainCommand, this.subCommand);
            if (!command.isPresent()) {
                throw new CommandWrongSubCommandException(this.mainCommand.toUpperCase(), this.subCommand);
            }
        }
        if (command.isPresent()) {
            Request result = Request.builder().command(command.get()).args(this.toValues(this.args)).build();
            this.isCompleted = true;
            return result;
        }
        throw new UnsupportedCommandException(this.mainCommand);
    }

    @Override
    public synchronized void release() {
        if (this.isCompleted) {
            return;
        }
        if (this.nextContents != null) {
            ByteBufUtil.release((ByteBuf)this.nextContents);
        }
        for (ByteBuf each : this.args) {
            ByteBufUtil.release(each);
        }
    }

    private List<Value<?>> toValues(List<ByteBuf> args) {
        ArrayList result = new ArrayList(args.size());
        for (ByteBuf each : args) {
            result.add(Value.newBuffer(each));
        }
        return result;
    }
}

