/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.protocol;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public enum CommandType {
    TYPE("Determine the type stored at key"),
    TTL("Get the time(seconds) to live for a key"),
    EXPIRE(4, "Set a key's time to live in seconds"),
    DEL(4, "Delete a key"),
    EXISTS("Determine if a key exists"),
    EXPIREAT(4, "Set the expiration for a key as a UNIX timestamp"),
    KEYS("Find all keys matching the given pattern"),
    KEYSIZE("Get the size of keys that matching the given pattern"),
    DBSIZE("Get the size of the all cache"),
    SCAN("Incrementally iterate the keys space"),
    SCANDATA("Incrementally iterate the keys space, but return more information then 'scan'"),
    SETEX(4, "Set the value and expiration of a key"),
    SET(4, "Set the string value of a key"),
    GET("Get the value of a key"),
    INCRBY(4, "Increment the integer value of a key by the given amount"),
    INCR(4, "Increment the integer value of a key by one"),
    DECRBY(4, "Decrement the integer value of a key by the given amount"),
    DECR(4, "Decrement the integer value of a key by one"),
    STRLEN("Get the length of the value stored in a key"),
    LINDEX("Get an element from a list by its index"),
    RPUSH(4, "Append one or multiple values to a list"),
    LREM(4, "Remove elements from a list"),
    LLEN("Get the length of a list"),
    LINSERT(4, "Insert an element before or after another element in a list"),
    LSET(4, "Set the value of an element in a list by its index"),
    LRANGE("Get a range of elements from a list"),
    SADD(4, "Add one or more members to a set"),
    SREM(4, "Remove one or more members from a set"),
    SMEMBERS("Get all the members in a set"),
    SCARD("Get the number of members in a set"),
    HMSET(4, "Set multiple hash fields to multiple values"),
    HMGET("Get the values of all the given hash fields"),
    HSET(4, "Set the string value of a hash field"),
    HGETALL("Get all the fields and values in a hash"),
    HGET("Get the value of a hash field"),
    HEXISTS("Determine if a hash field exists"),
    HDEL(4, "Delete one or more hash fields"),
    HKEYS("Get all the fields in a hash"),
    HLEN("Get the number of fields in a hash"),
    HSTRLEN("Get the length of the value of a hash field"),
    HSETEX(4, ""),
    HMSETEX(4, ""),
    QUIT(2, "Close the connection"),
    AUTH(2, "Authenticate to the server"),
    PING("Ping the server"),
    COMMAND("Get all supported commands"),
    MAN("Get command manual"),
    FLUSHALL(4, "Remove all keys from the cache service"),
    INFO("Get information and statistics about the server"),
    SLOWLOG_GET("SLOWLOG", "GET", 0, "Get the slow logs in chronological order"),
    SLOWLOG_LEN("SLOWLOG", "LEN", 0, "Get current size of slow logs"),
    SLOWLOG_RESET("SLOWLOG", "RESET", 0, "Clear all slow logs"),
    MEMORY_USAGE("MEMORY", "USAGE", 0, "Estimate the memory usage of a key"),
    CLEAR_EXPIRE(5, "Clear expire cache"),
    RESET_MEMORY(5, "Reset cache used memory to given size"),
    RESET_SIZE(5, "Reset cache size to the given size");

    private final int flag;
    private final String desc;
    private final String mainCommand;
    private final String subCommand;
    private final String commandName;
    private static final Map<String, CommandType[]> TYPE_MAP;
    private static final Set<String> SUB_COMMANDS;

    private CommandType(String desc) {
        this(0, desc);
    }

    private CommandType(int flag, String desc) {
        this(null, null, flag, desc);
    }

    private CommandType(String mainCommand, String subCommand, int flag, String desc) {
        this.flag = 0 | flag;
        this.desc = desc;
        this.mainCommand = mainCommand == null ? this.name() : mainCommand.toUpperCase();
        this.subCommand = subCommand == null || subCommand.trim().isEmpty() ? null : subCommand.toUpperCase();
        this.commandName = this.initCommandName();
    }

    private String initCommandName() {
        if (this.subCommand == null) {
            return this.mainCommand;
        }
        return String.format("%s %s", this.mainCommand, this.subCommand);
    }

    private static void registerType(CommandType type) {
        CommandType[] types = TYPE_MAP.get(type.mainCommand);
        if (types == null) {
            TYPE_MAP.put(type.mainCommand, new CommandType[]{type});
        } else {
            CommandType[] newCommandTypes = new CommandType[types.length + 1];
            System.arraycopy(types, 0, newCommandTypes, 0, types.length);
            newCommandTypes[newCommandTypes.length - 1] = type;
            TYPE_MAP.put(type.mainCommand, newCommandTypes);
        }
        if (type.subCommand != null) {
            SUB_COMMANDS.add(type.mainCommand);
        }
    }

    public String desc() {
        return this.desc;
    }

    public boolean isInnerCommand() {
        return this.check(1);
    }

    private boolean check(int mask) {
        return (this.flag & mask) != 0;
    }

    public boolean noAuth() {
        return this.check(2);
    }

    public boolean dataWrite() {
        return this.check(4);
    }

    public String commandName() {
        return this.commandName;
    }

    public String mainCommand() {
        return this.mainCommand;
    }

    public String subCommand() {
        return this.subCommand;
    }

    public static boolean hasSubCommand(String mainCommand) {
        if (mainCommand == null) {
            return false;
        }
        return SUB_COMMANDS.contains(mainCommand.trim().toUpperCase());
    }

    public static Optional<CommandType> findCommandType(String mainCommand, String subCommand) {
        if (mainCommand == null || subCommand == null) {
            return Optional.empty();
        }
        CommandType[] types = TYPE_MAP.get(mainCommand.trim().toUpperCase());
        if (types == null) {
            return Optional.empty();
        }
        String upperSubCommand = subCommand.trim().toUpperCase();
        for (CommandType each : types) {
            if (!each.subCommand.equals(upperSubCommand)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public static Optional<CommandType> findCommandType(String mainCommand) {
        if (mainCommand == null) {
            return Optional.empty();
        }
        String upperCommand = mainCommand.trim().toUpperCase();
        if (SUB_COMMANDS.contains(upperCommand)) {
            return Optional.empty();
        }
        CommandType[] types = TYPE_MAP.get(upperCommand);
        if (types == null) {
            return Optional.empty();
        }
        return Optional.of(types[0]);
    }

    public String toString() {
        return this.commandName;
    }

    static {
        TYPE_MAP = new HashMap<String, CommandType[]>(128);
        SUB_COMMANDS = new HashSet<String>(32);
        for (CommandType type : CommandType.values()) {
            CommandType.registerType(type);
        }
    }
}

